/*
 * Decompiled with CFR 0.152.
 */
package gate.lib.interaction.process.pipes;

import com.fasterxml.jackson.databind.ObjectMapper;
import gate.lib.interaction.process.ProcessBase;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Process4JsonStream
extends ProcessBase {
    private final Object synchronizer = new Object();
    private final ObjectMapper mapper = new ObjectMapper();
    private BufferedReader ir;
    private PrintStream ps;

    private Process4JsonStream() {
    }

    public static Process4JsonStream create(File workingDirectory, Map<String, String> env, List<String> command) {
        Process4JsonStream ret = new Process4JsonStream();
        if (workingDirectory != null) {
            ret.workingDir = workingDirectory;
        }
        if (env != null) {
            ret.envvars.putAll(env);
        }
        ret.command.addAll(command);
        ret.updateCommand4OS(ret.command);
        ret.ensureProcess();
        return ret;
    }

    public static Process4JsonStream create(File workingDirectory, Map<String, String> env, String ... command) {
        Process4JsonStream ret = new Process4JsonStream();
        if (workingDirectory != null) {
            ret.workingDir = workingDirectory;
        }
        if (env != null) {
            ret.envvars.putAll(env);
        }
        ret.command.addAll(Arrays.asList(command));
        ret.updateCommand4OS(ret.command);
        ret.ensureProcess();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object process(Object data) {
        try {
            Object object = this.synchronizer;
            synchronized (object) {
                String json = this.mapper.writeValueAsString(data);
                this.ps.println(json);
                this.ps.flush();
                json = "";
                while (json != null && !json.trim().startsWith("{")) {
                    try {
                        json = this.ir.readLine();
                    }
                    catch (EOFException eofex) {
                        return null;
                    }
                }
                if (json == null) {
                    return null;
                }
                Object obj = this.mapper.readValue(json, Map.class);
                return obj;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem when writing to output connection", ex);
        }
    }

    @Override
    public boolean isAlive() {
        return !this.need2start();
    }

    @Override
    protected void setupInteraction() {
        try {
            this.ps = new PrintStream(this.process.getOutputStream());
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create output connection", ex);
        }
        try {
            InputStream pis = this.process.getInputStream();
            this.ir = new BufferedReader(new InputStreamReader(pis, "UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create input connection", ex);
        }
        this.copyStream(this.process.getErrorStream(), System.out);
    }

    @Override
    protected void stopInteraction() {
        this.stopRequested = true;
        try {
            this.ir.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

