/*
 * Decompiled with CFR 0.152.
 */
package gate.lib.interaction.process.pipes;

import gate.lib.interaction.process.ProcessBase;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Process4ObjectStream
extends ProcessBase {
    private final Object synchronizer = new Object();
    private ObjectInputStream ois;
    private ObjectOutputStream oos;

    private Process4ObjectStream() {
    }

    public static Process4ObjectStream create(File workingDirectory, Map<String, String> env, List<String> command) {
        Process4ObjectStream ret = new Process4ObjectStream();
        if (workingDirectory != null) {
            ret.workingDir = workingDirectory;
        }
        if (env != null) {
            ret.envvars.putAll(env);
        }
        ret.command.addAll(command);
        ret.updateCommand4OS(ret.command);
        ret.ensureProcess();
        return ret;
    }

    public static Process4ObjectStream create(File workingDirectory, Map<String, String> env, String ... command) {
        Process4ObjectStream ret = new Process4ObjectStream();
        if (workingDirectory != null) {
            ret.workingDir = workingDirectory;
        }
        if (env != null) {
            ret.envvars.putAll(env);
        }
        ret.command.addAll(Arrays.asList(command));
        ret.updateCommand4OS(ret.command);
        ret.ensureProcess();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object process(Object data) {
        try {
            Object object = this.synchronizer;
            synchronized (object) {
                this.oos.writeObject(data);
                this.oos.flush();
                try {
                    return this.ois.readObject();
                }
                catch (EOFException eofex) {
                    return null;
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Problem when writing to object stream", ex);
        }
    }

    @Override
    public boolean isAlive() {
        return !this.need2start();
    }

    @Override
    protected void setupInteraction() {
        try {
            this.oos = new ObjectOutputStream(this.process.getOutputStream());
            this.oos.writeObject("Hello from Process4ObjectStream v1.0");
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create object output stream", ex);
        }
        try {
            InputStream pis = this.process.getInputStream();
            this.ois = new ObjectInputStream(pis);
            try {
                Object ret = this.ois.readObject();
                System.err.println("Got hello from process: " + ret);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not receive the other side's hello object");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create object input stream", ex);
        }
        this.copyStream(this.process.getErrorStream(), System.out);
    }

    @Override
    protected void stopInteraction() {
        this.stopRequested = true;
        try {
            this.ois.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

