/*
 * Decompiled with CFR 0.152.
 */
package gate.lib.interaction.process.pipes;

import gate.lib.interaction.process.ProcessBase;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Process4StringStream
extends ProcessBase {
    private final Object synchronizer = new Object();
    private BufferedReader ir;
    private PrintStream ps;

    private Process4StringStream() {
    }

    public static Process4StringStream create(File workingDirectory, Map<String, String> env, List<String> command) {
        Process4StringStream ret = new Process4StringStream();
        if (workingDirectory != null) {
            ret.workingDir = workingDirectory;
        }
        if (env != null) {
            ret.envvars.putAll(env);
        }
        ret.command.addAll(command);
        ret.updateCommand4OS(ret.command);
        ret.ensureProcess();
        return ret;
    }

    public static Process4StringStream create(File workingDirectory, Map<String, String> env, String ... command) {
        Process4StringStream ret = new Process4StringStream();
        if (workingDirectory != null) {
            ret.workingDir = workingDirectory;
        }
        if (env != null) {
            ret.envvars.putAll(env);
        }
        ret.command.addAll(Arrays.asList(command));
        ret.updateCommand4OS(ret.command);
        ret.ensureProcess();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object process(Object data) {
        try {
            Object object = this.synchronizer;
            synchronized (object) {
                String str = (String)data;
                this.ps.println(str);
                this.ps.flush();
                try {
                    str = this.ir.readLine();
                    return str;
                }
                catch (EOFException eofex) {
                    return null;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem when writing to output connection", ex);
        }
    }

    @Override
    public boolean isAlive() {
        return !this.need2start();
    }

    @Override
    protected void setupInteraction() {
        try {
            this.ps = new PrintStream(this.process.getOutputStream(), false, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create output connection", ex);
        }
        try {
            InputStream pis = this.process.getInputStream();
            this.ir = new BufferedReader(new InputStreamReader(pis, "UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create input connection", ex);
        }
        this.copyStream(this.process.getErrorStream(), System.out);
    }

    @Override
    protected void stopInteraction() {
        this.stopRequested = true;
        try {
            this.ir.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

