/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.DocumentContent;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.corpora.MimeType;
import gate.corpora.TextualDocumentFormat;
import gate.corpora.json.JSONDocument;
import gate.corpora.json.JSONDocumentStreamIterator;
import gate.corpora.json.PreAnnotation;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.util.DocumentFormatException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.activation.MimeTypeParseException;
import org.apache.commons.lang.StringUtils;

@CreoleResource(name="GATE JSON Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)}, comment="Format parser for Twitter JSON files", helpURL="http://gate.ac.uk/userguide/sec:social:twitter:format")
public class GATEJSONFormat
extends TextualDocumentFormat {
    private static final long serialVersionUID = 6878020036304333918L;

    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "json");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        suffixes2mimeTypeMap.put("json", mime);
        this.setMimeType(mime);
        return this;
    }

    public void cleanup() {
        super.cleanup();
        MimeType mime = this.getMimeType();
        mimeString2ClassHandlerMap.remove(mime.getType() + "/" + mime.getSubtype());
        mimeString2mimeTypeMap.remove(mime.getType() + "/" + mime.getSubtype());
        suffixes2mimeTypeMap.remove("json");
    }

    public void unpackMarkup(Document doc) throws DocumentFormatException {
        if (doc == null || doc.getSourceUrl() == null && doc.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        String textPath = "text";
        if (doc instanceof DocumentImpl) {
            try {
                MimeType mimeType = new MimeType(((DocumentImpl)doc).getMimeType());
                String paramValue = mimeType.getParameterValue("text-path");
                if (paramValue != null && !paramValue.trim().isEmpty()) {
                    textPath = paramValue;
                }
            }
            catch (RuntimeException | MimeTypeParseException e) {
                e.printStackTrace();
            }
        }
        this.setNewLineProperty(doc);
        String jsonString = StringUtils.trimToEmpty((String)doc.getContent().toString());
        try {
            JSONDocumentStreamIterator tweetSource = new JSONDocumentStreamIterator(jsonString, textPath);
            LinkedHashMap<JSONDocument, Long> tweetStarts = new LinkedHashMap<JSONDocument, Long>();
            StringBuilder concatenation = new StringBuilder();
            while (tweetSource.hasNext()) {
                JSONDocument tweet = (JSONDocument)tweetSource.next();
                if (tweet == null) continue;
                tweetStarts.put(tweet, Long.valueOf(concatenation.length()));
                concatenation.append(tweet.getString()).append("\n\n");
            }
            DocumentContentImpl newContent = new DocumentContentImpl(concatenation.toString());
            doc.edit(Long.valueOf(0L), doc.getContent().size(), (DocumentContent)newContent);
            for (Map.Entry entry : tweetStarts.entrySet()) {
                for (PreAnnotation preAnn : ((JSONDocument)entry.getKey()).getAnnotations()) {
                    preAnn.toAnnotation(doc, (long)((Long)entry.getValue()));
                }
            }
        }
        catch (InvalidOffsetException | IOException | RuntimeException e) {
            doc.getFeatures().put((Object)"parsingError", (Object)Boolean.TRUE);
            Boolean bThrow = (Boolean)doc.getFeatures().get((Object)"throwExceptionOnFormatError");
            if (bThrow != null && bThrow.booleanValue()) {
                throw new DocumentFormatException((Exception)e);
            }
            Out.println((String)"Warning: Document remains unparsed. \n\n  Stack Dump: ");
            e.printStackTrace(Out.getPrintWriter());
        }
    }
}

