/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.export;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.ObjectMapper;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.CorpusExporter;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.SimpleAnnotation;
import gate.SimpleDocument;
import gate.Utils;
import gate.corpora.DocumentJsonUtils;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@CreoleResource(name="GATE JSON Exporter", comment="Export documents and corpora in JSON format", tool=true, autoinstances={@AutoInstance}, icon="GATEJSON")
public class GATEJsonExporter
extends CorpusExporter {
    private static final long serialVersionUID = -8087536348560365618L;
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    @Optional
    @RunTime
    @CreoleParameter(comment="The annotation set from which otherwise-unspecified entity annotations will be taken")
    public void setEntitiesAnnotationSetName(String name) {
    }

    public String getEntitiesAnnotationSetName() {
        return null;
    }

    @RunTime
    @CreoleParameter(comment="Annotation types to export.  Plain annotation types will be taken from the set named by the annotationSetName parameter, entries containing a colon are treated as setName:type (with an empty setName denoting the default set).")
    public void setAnnotationTypes(Set<String> types) {
    }

    public Set<String> getAnnotationTypes() {
        return null;
    }

    @RunTime
    @CreoleParameter(defaultValue="false", comment="Whether to wrap the output as a JSON array.  When exporting a corpus, true will write a JSON array of objects, one per document, whereas false will simply output one object per document separated by newlines.")
    public void setExportAsArray(Boolean array) {
    }

    public Boolean getExportAsArray() {
        return Boolean.FALSE;
    }

    @RunTime
    @Optional
    @CreoleParameter(defaultValue="Original markups", comment="Annotation set in which the \"document annotation\" can be found.  These annotations serve to delimit the parts of the document that should be output, and the result will contain one JSON object per annotation, with the annotation's features as additional JSON properties.")
    public void setDocumentAnnotationASName(String asName) {
    }

    public String getDocumentAnnotationASName() {
        return null;
    }

    @RunTime
    @Optional
    @CreoleParameter(defaultValue="Object", comment="Annotation type for \"document annotations\".  These annotations serve to delimit the parts of the document that should be output, and the result will contain one JSON object per annotation, with the annotation's features as additional JSON properties.  If unspecified, or if a given GATE document contains none of these annotations, then the whole document content will be output.")
    public void setDocumentAnnotationType(String type) {
    }

    public String getDocumentAnnotationType() {
        return null;
    }

    public GATEJsonExporter() {
        super("GATE JSON", "json", "application/json");
    }

    public void export(Document doc, OutputStream out, FeatureMap options) throws IOException {
        try (JsonGenerator generator = this.openGenerator(out, options);){
            this.export(doc, generator, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Corpus corpus, OutputStream out, FeatureMap options) throws IOException {
        try (JsonGenerator generator = this.openGenerator(out, options);){
            Iterator docIter = corpus.iterator();
            int currentDocIndex = 0;
            while (docIter.hasNext()) {
                boolean docWasLoaded = corpus.isDocumentLoaded(currentDocIndex);
                Document currentDoc = (Document)docIter.next();
                try {
                    this.export(currentDoc, generator, options);
                }
                finally {
                    if (!docWasLoaded) {
                        corpus.unloadDocument(currentDoc);
                        Factory.deleteResource((Resource)currentDoc);
                    }
                    ++currentDocIndex;
                }
            }
        }
    }

    protected JsonGenerator openGenerator(OutputStream out, FeatureMap options) throws IOException {
        JsonGenerator generator = MAPPER.getFactory().createGenerator((Writer)new OutputStreamWriter(out, "UTF-8"));
        generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        generator.enable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        if (options.containsKey((Object)"exportAsArray") && ((Boolean)options.get((Object)"exportAsArray")).booleanValue()) {
            generator.writeStartArray();
        } else {
            generator.setRootValueSeparator((SerializableString)new SerializedString("\n"));
        }
        return generator;
    }

    public void export(Document doc, JsonGenerator generator, FeatureMap options) throws IOException {
        try {
            AnnotationSet defaultEntitiesAS = doc.getAnnotations((String)options.get((Object)"entitiesAnnotationSetName"));
            Collection types = (Collection)options.get((Object)"annotationTypes");
            LinkedHashMap<String, AnnotationSet> annotationsMap = new LinkedHashMap<String, AnnotationSet>();
            if (types != null && !types.isEmpty()) {
                for (String type : types) {
                    String[] setAndType = type.split(":", 2);
                    if (setAndType.length == 1) {
                        annotationsMap.put(type, defaultEntitiesAS.get(type));
                        continue;
                    }
                    annotationsMap.put(type, doc.getAnnotations(setAndType[0]).get(setAndType[1]));
                }
            }
            AnnotationSet docAnnots = null;
            if (options.containsKey((Object)"documentAnnotationType")) {
                docAnnots = doc.getAnnotations((String)options.get((Object)"documentAnnotationASName")).get((String)options.get((Object)"documentAnnotationType"));
            }
            if (docAnnots == null || docAnnots.isEmpty()) {
                LinkedHashMap sortedAnnots = new LinkedHashMap();
                for (Map.Entry entry : annotationsMap.entrySet()) {
                    sortedAnnots.put(entry.getKey(), Utils.inDocumentOrder((AnnotationSet)((AnnotationSet)entry.getValue())));
                }
                DocumentJsonUtils.writeDocument((Document)doc, (Long)0L, (Long)Utils.end((SimpleDocument)doc), sortedAnnots, null, null, (JsonGenerator)generator);
            } else {
                for (Annotation docAnnot : Utils.inDocumentOrder(docAnnots)) {
                    HashMap hashMap = new HashMap();
                    for (Map.Entry entry : annotationsMap.entrySet()) {
                        hashMap.put(entry.getKey(), Utils.inDocumentOrder((AnnotationSet)((AnnotationSet)entry.getValue()).getContained(Utils.start((SimpleAnnotation)docAnnot), Utils.end((SimpleAnnotation)docAnnot))));
                    }
                    DocumentJsonUtils.writeDocument((Document)doc, (Long)Utils.start((SimpleAnnotation)docAnnot), (Long)Utils.end((SimpleAnnotation)docAnnot), hashMap, (Map)docAnnot.getFeatures(), null, (JsonGenerator)generator);
                }
            }
        }
        catch (InvalidOffsetException e) {
            throw new GateRuntimeException("Invalid offset found within document", (Throwable)e);
        }
    }
}

