/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.RepositioningInfo;
import gate.corpora.json.JSONUtils;
import gate.corpora.json.PreAnnotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONDocument {
    private String string = "";
    private Set<PreAnnotation> annotations = new HashSet<PreAnnotation>();
    private static Pattern UNESCAPE_PATTERN = Pattern.compile("&(?:amp|lt|gt);|[\\x{" + Integer.toHexString(65536) + "}-\\x{" + Integer.toHexString(0x10FFFF) + "}]");

    public Set<PreAnnotation> getAnnotations() {
        return this.annotations;
    }

    public int getLength() {
        return this.string.length();
    }

    public String getString() {
        return this.string;
    }

    protected JSONDocument(JsonNode json, String textPath, boolean handleEntities) {
        String[] path = textPath.split("\\.");
        JsonNode current = json;
        for (int i = 0; i < path.length - 1; ++i) {
            current = json.get(path[i]);
        }
        RepositioningInfo repos = new RepositioningInfo();
        this.string = this.unescape(((ObjectNode)current).remove(path[path.length - 1]).asText(), repos);
        if (handleEntities) {
            this.processEntities(current, 0L, repos);
        }
        Iterator keys = json.fieldNames();
        FeatureMap features = Factory.newFeatureMap();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            features.put((Object)key, JSONUtils.process(json.get(key)));
        }
        this.annotations.add(new PreAnnotation(0L, this.string.length(), "Object", features));
    }

    private String unescape(String str, RepositioningInfo repos) {
        StringBuffer buf = new StringBuffer();
        int origOffset = 0;
        int extractedOffset = 0;
        Matcher mat = UNESCAPE_PATTERN.matcher(str);
        while (mat.find()) {
            if (mat.start() != origOffset) {
                int nonMatchLen = mat.start() - origOffset;
                repos.addPositionInfo((long)origOffset, (long)nonMatchLen, (long)extractedOffset, (long)nonMatchLen);
                origOffset += nonMatchLen;
                extractedOffset += nonMatchLen;
            }
            int origLen = mat.end() - mat.start();
            int extractedLen = 1;
            String replace = "?";
            switch (mat.group()) {
                case "&amp;": {
                    replace = "&";
                    break;
                }
                case "&gt;": {
                    replace = ">";
                    break;
                }
                case "&lt;": {
                    replace = "<";
                    break;
                }
                default: {
                    replace = mat.group();
                    origLen = 1;
                    extractedLen = 2;
                }
            }
            mat.appendReplacement(buf, replace);
            repos.addPositionInfo((long)origOffset, (long)origLen, (long)extractedOffset, (long)extractedLen);
            origOffset += origLen;
            extractedOffset += extractedLen;
        }
        int tailLen = str.length() - origOffset;
        if (tailLen > 0) {
            repos.addPositionInfo((long)origOffset, (long)(tailLen + 1), (long)extractedOffset, (long)(tailLen + 1));
        }
        mat.appendTail(buf);
        return buf.toString();
    }

    private void processEntities(JsonNode json, long startOffset, RepositioningInfo repos) {
        JsonNode entitiesNode = ((ObjectNode)json).remove("entities");
        if (entitiesNode == null || !entitiesNode.isObject()) {
            return;
        }
        Iterator entityTypes = entitiesNode.fieldNames();
        while (entityTypes.hasNext()) {
            String entityType = (String)entityTypes.next();
            JsonNode entitiesOfType = entitiesNode.get(entityType);
            if (entitiesOfType == null || !entitiesOfType.isArray() || entitiesOfType.size() <= 0) continue;
            String[] setAndType = entityType.split(":", 2);
            Iterator it = entitiesOfType.elements();
            while (it.hasNext()) {
                List indicesList;
                FeatureMap features;
                Object indices;
                JsonNode entity = (JsonNode)it.next();
                if (!entity.isObject() || (indices = (features = (FeatureMap)JSONUtils.process(entity)).get((Object)"indices")) == null || !(indices instanceof List) || !((indicesList = (List)indices).get(0) instanceof Number) || !(indicesList.get(1) instanceof Number)) continue;
                features.remove((Object)"indices");
                long annStart = repos.getExtractedPos(startOffset + ((Number)indicesList.get(0)).longValue());
                long annEnd = repos.getExtractedPos(startOffset + ((Number)indicesList.get(1)).longValue());
                if (setAndType.length == 2) {
                    this.annotations.add(new PreAnnotation(annStart, annEnd, setAndType[0], setAndType[1], features));
                    continue;
                }
                this.annotations.add(new PreAnnotation(annStart, annEnd, entityType, features));
            }
        }
    }
}

