/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import gate.corpora.json.JSONDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class JSONDocumentStreamIterator
implements Iterator<JSONDocument> {
    private ObjectMapper objectMapper;
    private JsonParser jsonParser;
    private MappingIterator<JsonNode> iterator;
    private JsonNode nextNode;
    private boolean handleEntities;
    private String textPath;

    public JSONDocumentStreamIterator(String json, String textPath) throws JsonParseException, IOException {
        this(json, textPath, true);
    }

    public JSONDocumentStreamIterator(String json, String textPath, boolean handleEntities) throws JsonParseException, IOException {
        this.handleEntities = handleEntities;
        this.objectMapper = new ObjectMapper();
        this.jsonParser = this.objectMapper.getFactory().createParser(json);
        this.textPath = textPath;
        this.init();
    }

    public JSONDocumentStreamIterator(InputStream input, String textPath, boolean gzip) throws JsonParseException, IOException {
        this(input, textPath, gzip, true);
    }

    public JSONDocumentStreamIterator(InputStream input, String textPath, boolean gzip, boolean handleEntities) throws JsonParseException, IOException {
        this.handleEntities = handleEntities;
        this.textPath = textPath;
        this.objectMapper = new ObjectMapper();
        InputStream workingInput = gzip ? new GZIPInputStream(input) : input;
        this.jsonParser = this.objectMapper.getFactory().createParser(workingInput).enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        this.init();
    }

    private void init() throws JsonParseException, IOException {
        if (this.jsonParser.nextToken() == JsonToken.START_ARRAY) {
            this.jsonParser.clearCurrentToken();
        }
        this.iterator = this.objectMapper.readValues(this.jsonParser, JsonNode.class);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public JSONDocument next() {
        JSONDocument result = null;
        if (this.iterator.hasNext()) {
            this.nextNode = (JsonNode)this.iterator.next();
            result = new JSONDocument(this.nextNode, this.textPath, this.handleEntities);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The JSON document stream is read-only.");
    }

    public void close() throws IOException {
        this.iterator.close();
        this.jsonParser.close();
    }
}

