/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.json.JSONDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JSONUtils {
    public static final String PATH_SEPARATOR = ":";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String ANNOTATION_TYPE = "Object";
    public static final String DEFAULT_TEXT_ATTRIBUTE = "text";
    public static final String ENTITIES_ATTRIBUTE = "entities";

    public static List<JSONDocument> readJSONObjects(String string, String textPath) throws IOException {
        if (string.startsWith("[")) {
            return JSONUtils.readJSONObjectList(string, textPath);
        }
        return JSONUtils.readJSONObjectLines(string, textPath);
    }

    public static List<JSONDocument> readJSONObjectLines(String string, String textPath) throws IOException {
        String[] lines = string.split("[\\n\\r]+");
        return JSONUtils.readJSONObjectStrings(lines, textPath);
    }

    public static List<JSONDocument> readJSONObjectStrings(String[] lines, String textPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<JSONDocument> tweets = new ArrayList<JSONDocument>();
        for (String line : lines) {
            if (line.length() <= 0) continue;
            JsonNode jnode = mapper.readTree(line);
            tweets.add(new JSONDocument(jnode, textPath, true));
        }
        return tweets;
    }

    public static List<JSONDocument> readJSONObjectStrings(List<String> lines, String textPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<JSONDocument> tweets = new ArrayList<JSONDocument>();
        for (String line : lines) {
            if (line.length() <= 0) continue;
            JsonNode jnode = mapper.readTree(line);
            tweets.add(new JSONDocument(jnode, textPath, true));
        }
        return tweets;
    }

    public static List<JSONDocument> readJSONObjectList(String string, String textPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<JSONDocument> tweets = new ArrayList<JSONDocument>();
        ArrayNode jarray = (ArrayNode)mapper.readTree(string);
        for (JsonNode jnode : jarray) {
            tweets.add(new JSONDocument(jnode, textPath, true));
        }
        return tweets;
    }

    public static Object process(JsonNode node) {
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isIntegralNumber()) {
            if (node.canConvertToLong()) {
                return node.asLong();
            }
            return node.bigIntegerValue();
        }
        if (node.isNumber()) {
            return node.numberValue();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonNode item : node) {
                list.add(JSONUtils.process(item));
            }
            return list;
        }
        if (node.isObject()) {
            FeatureMap map = Factory.newFeatureMap();
            Iterator keys = node.fieldNames();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put((Object)key, JSONUtils.process(node.get(key)));
            }
            return map;
        }
        return node.toString();
    }

    public static FeatureMap process(JsonNode node, List<String> keepers) {
        FeatureMap found = Factory.newFeatureMap();
        for (String keeper : keepers) {
            String[] keySequence = StringUtils.split((String)keeper, (String)PATH_SEPARATOR);
            Object value = JSONUtils.dig(node, keySequence, 0);
            if (value == null) continue;
            found.put((Object)keeper, value);
        }
        return found;
    }

    public static Object dig(JsonNode node, String[] keySequence, int index) {
        if (index >= keySequence.length || node == null) {
            return null;
        }
        if (node.has(keySequence[index])) {
            JsonNode value = node.get(keySequence[index]);
            if (keySequence.length == index + 1) {
                return JSONUtils.process(value);
            }
            if (value != null) {
                return JSONUtils.dig(value, keySequence, index + 1);
            }
        }
        return null;
    }
}

