/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora.json;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.util.InvalidOffsetException;

public class PreAnnotation {
    private FeatureMap features;
    private String asName;
    private String type;
    private long start;
    private long end;

    public PreAnnotation(long start, long end, String type, FeatureMap features) {
        this(start, end, "Original markups", type, features);
    }

    public PreAnnotation(long start, long end, String asName, String type, FeatureMap features) {
        this.features = features == null ? Factory.newFeatureMap() : features;
        this.asName = asName;
        this.type = type;
        this.setStart(start);
        this.setEnd(end);
    }

    public PreAnnotation(long start, long end, String type) {
        this.features = Factory.newFeatureMap();
        this.type = type;
        this.setStart(start);
        this.setEnd(end);
    }

    public Annotation toAnnotation(Document doc, long startOffset) throws InvalidOffsetException {
        return this.toAnnotation(doc.getAnnotations(this.asName), startOffset);
    }

    public Annotation toAnnotation(AnnotationSet outputAS, long startOffset) throws InvalidOffsetException {
        long outputStart = this.start + startOffset;
        long outputEnd = this.end + startOffset;
        Integer id = outputAS.add(Long.valueOf(outputStart), Long.valueOf(outputEnd), this.type, this.features);
        return outputAS.get(id);
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureMap features) {
        this.features = features;
    }

    public String getASName() {
        return this.asName;
    }

    public String getType() {
        return this.type;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String toString() {
        return "PreAnnotation: from=" + this.getStart() + ",to=" + this.getEnd() + ",type=" + this.getType();
    }
}

