/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import gate.Corpus;
import gate.Document;
import gate.DocumentFormat;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.MimeType;
import gate.creole.Plugin;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.event.PluginListener;
import gate.gui.MainFrame;
import gate.gui.NameBearerHandle;
import gate.gui.ResourceHelper;
import gate.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.activation.MimeTypeParseException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

@CreoleResource(name="JSON Corpus Populator", tool=true, autoinstances={@AutoInstance})
public class JsonCorpusPopulator
extends ResourceHelper
implements PluginListener {
    private static final Logger logger = Logger.getLogger((String)JsonCorpusPopulator.class.getName());
    private static final long serialVersionUID = -1712269859711281005L;
    private JDialog dialog = null;
    private JComboBox<String> cboMimeType;
    private JTextField txtIDPath;
    private JFileChooser fileChooser;
    private int returnValue;
    private static final int ERROR = -1;
    private static final int CANCEL = 0;
    private static final int APPROVE = 1;

    private void buildGUI() {
        this.dialog = new JDialog((Window)MainFrame.getInstance(), "Populate from JSON...", Dialog.DEFAULT_MODALITY_TYPE);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(1);
        this.fileChooser = new JFileChooser();
        MainFrame.getGuiRoots().add(this.dialog);
        JPanel options = new JPanel(new SpringLayout());
        options.setBorder(new TitledBorder("Options:"));
        this.cboMimeType = new JComboBox();
        this.updateMimeTypeList();
        Gate.getCreoleRegister().addPluginListener((PluginListener)this);
        this.cboMimeType.setEditable(true);
        this.txtIDPath = new JTextField();
        options.add(new JLabel("Mime Type:"));
        options.add(this.cboMimeType);
        options.add(new JLabel("Doc ID Field"));
        options.add(this.txtIDPath);
        SpringUtilities.makeCompactGrid((Container)options, (int)2, (int)2, (int)5, (int)5, (int)3, (int)3);
        this.dialog.getContentPane().add((Component)options, "North");
        this.dialog.getContentPane().add((Component)this.fileChooser, "Center");
        this.dialog.pack();
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JsonCorpusPopulator.this.returnValue = 0;
            }
        });
        this.fileChooser.addActionListener(e -> {
            if ("ApproveSelection".equals(e.getActionCommand())) {
                this.cboMimeType.getEditor().getEditorComponent().setBackground(UIManager.getColor("TextField.background"));
                this.txtIDPath.setBackground(UIManager.getColor("TextField.background"));
                try {
                    DocumentFormat format = DocumentFormat.getDocumentFormat((MimeType)new MimeType(this.cboMimeType.getSelectedItem().toString()));
                    if (format == null) {
                        this.cboMimeType.requestFocusInWindow();
                        this.cboMimeType.getEditor().getEditorComponent().setBackground(new Color(255, 186, 186));
                        System.err.println("no handler for mime type");
                        return;
                    }
                }
                catch (Exception ex) {
                    this.cboMimeType.requestFocusInWindow();
                    this.cboMimeType.getEditor().getEditorComponent().setBackground(new Color(255, 186, 186));
                    this.cboMimeType.setBackground(new Color(255, 186, 186));
                    System.err.println("invalid mime type");
                    return;
                }
                try {
                    if (!this.txtIDPath.getText().trim().isEmpty()) {
                        JsonPointer ex = JsonPointer.compile((String)this.txtIDPath.getText().trim());
                    }
                }
                catch (RuntimeException ex) {
                    System.err.println("invalid JSON path to ID element");
                    this.txtIDPath.requestFocusInWindow();
                    this.txtIDPath.setBackground(new Color(255, 186, 186));
                    this.txtIDPath.setSelectionEnd(this.txtIDPath.getText().length());
                    this.txtIDPath.setSelectionStart(0);
                    return;
                }
                this.returnValue = 1;
            } else {
                this.returnValue = 0;
            }
            this.dialog.setVisible(false);
        });
    }

    protected List<Action> buildActions(final NameBearerHandle handle) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!(handle.getTarget() instanceof Corpus)) {
            return actions;
        }
        actions.add(new AbstractAction("Populate from JSON..."){
            private static final long serialVersionUID = -8992528339144621526L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (JsonCorpusPopulator.this.dialog == null) {
                    JsonCorpusPopulator.this.buildGUI();
                }
                JsonCorpusPopulator.this.cboMimeType.getEditor().getEditorComponent().setBackground(UIManager.getColor("TextField.background"));
                JsonCorpusPopulator.this.txtIDPath.setBackground(UIManager.getColor("TextField.background"));
                JsonCorpusPopulator.this.dialog.setLocationRelativeTo(JsonCorpusPopulator.this.dialog.getParent());
                JsonCorpusPopulator.this.returnValue = -1;
                JsonCorpusPopulator.this.dialog.setVisible(true);
                if (JsonCorpusPopulator.this.returnValue != 1) {
                    return;
                }
                String mimeType = JsonCorpusPopulator.this.cboMimeType.getSelectedItem().toString().trim();
                String idPath = JsonCorpusPopulator.this.txtIDPath.getText().trim();
                new Thread(() -> {
                    try {
                        try (FileInputStream in = new FileInputStream(JsonCorpusPopulator.this.fileChooser.getSelectedFile());
                             GZIPInputStream gzin = new GZIPInputStream(in);){
                            JsonCorpusPopulator.this.populate((Corpus)handle.getTarget(), gzin, mimeType, idPath.isEmpty() ? null : idPath);
                        }
                        catch (ZipException zippy) {
                            try (FileInputStream in2 = new FileInputStream(JsonCorpusPopulator.this.fileChooser.getSelectedFile());){
                                JsonCorpusPopulator.this.populate((Corpus)handle.getTarget(), in2, mimeType, idPath.isEmpty() ? null : idPath);
                            }
                        }
                    }
                    catch (IOException bungle) {
                        bungle.printStackTrace();
                    }
                }).start();
            }
        });
        return actions;
    }

    public void populate(Corpus corpus, InputStream inputStream, String mimeType, String idPath) throws IOException {
        ObjectMapper objectMapper;
        JsonParser jsonParser;
        JsonPointer idPointer = null;
        if (idPath != null) {
            idPointer = JsonPointer.compile((String)idPath);
        }
        if ((jsonParser = (objectMapper = new ObjectMapper()).getFactory().createParser(inputStream).enable(JsonParser.Feature.AUTO_CLOSE_SOURCE)).nextToken() == JsonToken.START_ARRAY) {
            jsonParser.clearCurrentToken();
        }
        MappingIterator docIterator = objectMapper.readValues(jsonParser, JsonNode.class);
        while (docIterator.hasNext()) {
            JsonNode json = (JsonNode)docIterator.next();
            String docID = null;
            if (idPointer != null && ((docID = json.at(idPointer).asText()) == null || docID.trim().isEmpty())) continue;
            FeatureMap docParams = Factory.newFeatureMap();
            docParams.put((Object)"stringContent", (Object)json.toString());
            if (mimeType != null) {
                docParams.put((Object)"mimeType", (Object)mimeType);
            }
            try {
                Document document = (Document)Factory.createResource((String)"gate.corpora.DocumentImpl", (FeatureMap)docParams, (FeatureMap)Factory.newFeatureMap(), (String)docID);
                corpus.add((Object)document);
                if (corpus.getLRPersistenceId() == null) continue;
                corpus.unloadDocument(document);
                Factory.deleteResource((Resource)document);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to correctly parse JSON document", (Throwable)e);
            }
        }
    }

    public void pluginLoaded(Plugin plugin) {
        this.updateMimeTypeList();
    }

    public void pluginUnloaded(Plugin plugin) {
        this.updateMimeTypeList();
    }

    private void updateMimeTypeList() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cboMimeType.getModel();
        Object selected = this.cboMimeType.getSelectedItem();
        model.removeAllElements();
        TreeSet<String> knownMimeTypes = new TreeSet<String>();
        for (String mimeType : DocumentFormat.getSupportedMimeTypes()) {
            if (mimeType.toLowerCase(Locale.ENGLISH).indexOf("json") != -1) {
                knownMimeTypes.add(mimeType);
                continue;
            }
            try {
                MimeType mimeTypeObj = new MimeType(mimeType);
                DocumentFormat docFormat = DocumentFormat.getDocumentFormat((MimeType)mimeTypeObj);
                if (docFormat == null || docFormat.getName().toLowerCase(Locale.ENGLISH).indexOf("json") == -1) continue;
                knownMimeTypes.add(mimeType);
            }
            catch (MimeTypeParseException mimeTypeParseException) {}
        }
        for (String known : knownMimeTypes) {
            model.addElement(known);
        }
        if (selected != null && knownMimeTypes.contains(selected)) {
            this.cboMimeType.setSelectedItem(selected);
        }
    }
}

