/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.DocumentContent;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.MimeType;
import gate.corpora.NekoHtmlDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.util.DocumentFormatException;
import info.bliki.wiki.model.WikiModel;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

@CreoleResource(name="MediaWiki Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)}, comment="Document format for parsing MediaWiki markup", helpURL="http://gate.ac.uk/userguide/sec:creole:mediawiki")
public class MediaWikiDocumentFormat
extends NekoHtmlDocumentFormat {
    private static final long serialVersionUID = 2979612569607249915L;
    private final WikiModel model = new WikiModel("${image}", "${title}"){

        public String getRawWikiContent(String namespace, String articleName, Map<String, String> templateParameters) {
            String rawContent = super.getRawWikiContent(namespace, articleName, templateParameters);
            if (rawContent == null) {
                return "";
            }
            return rawContent;
        }
    };

    public Boolean supportsRepositioning() {
        return false;
    }

    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "x-mediawiki");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        this.setMimeType(mime);
        return this;
    }

    public void cleanup() {
        super.cleanup();
        MimeType mime = this.getMimeType();
        mimeString2ClassHandlerMap.remove(mime.getType() + "/" + mime.getSubtype());
        mimeString2mimeTypeMap.remove(mime.getType() + "/" + mime.getSubtype());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpackMarkup(Document doc) throws DocumentFormatException {
        try {
            this.model.setUp();
            String unescaped = StringEscapeUtils.unescapeHtml((String)doc.getContent().toString());
            String htmlText = this.model.render(unescaped);
            doc.setContent((DocumentContent)new DocumentContentImpl(htmlText));
            URL url = doc.getSourceUrl();
            doc.setSourceUrl(null);
            super.unpackMarkup(doc);
            doc.setSourceUrl(url);
        }
        finally {
            this.model.tearDown();
        }
    }
}

