/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.gui.MainFrame;
import gate.gui.NameBearerHandle;
import gate.gui.ResourceHelper;
import gate.swing.XJFileChooser;
import gate.util.ExtensionFileFilter;
import info.bliki.wiki.dump.IArticleFilter;
import info.bliki.wiki.dump.Siteinfo;
import info.bliki.wiki.dump.WikiArticle;
import info.bliki.wiki.dump.WikiXMLParser;
import info.bliki.wiki.model.WikiModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.SAXException;

@CreoleResource(name="MediaWiki Corpus Populater", tool=true, autoinstances={@AutoInstance}, comment="Populate a corpus from a MediaWiki XML dump", helpURL="http://gate.ac.uk/userguide/sec:creole:mediawiki")
public class MediaWikiPopulater
extends ResourceHelper {
    private static final long serialVersionUID = -2505026690286047751L;
    private static final WikiModel model = new WikiModel("${image}", "${title}"){

        public String getRawWikiContent(String namespace, String articleName, Map<String, String> templateParameters) {
            String rawContent = super.getRawWikiContent(namespace, articleName, templateParameters);
            if (rawContent == null) {
                return "";
            }
            return rawContent;
        }
    };

    protected List<Action> buildActions(final NameBearerHandle handle) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!(handle.getTarget() instanceof Corpus)) {
            return actions;
        }
        actions.add(new AbstractAction("Populate from MediaWiki XML Dump"){

            @Override
            public void actionPerformed(ActionEvent e) {
                XJFileChooser filer = MainFrame.getFileChooser();
                filer.setFileSelectionMode(0);
                filer.setDialogTitle("Select a MediaWiki XML Dump File");
                filer.resetChoosableFileFilters();
                filer.setAcceptAllFileFilterUsed(false);
                ExtensionFileFilter filter = new ExtensionFileFilter("MediaWiki XML Dump Files (*.xml)", new String[]{"xml"});
                filer.addChoosableFileFilter((FileFilter)filter);
                filer.setFileFilter((FileFilter)filter);
                if (filer.showOpenDialog((Component)MainFrame.getInstance()) != 0) {
                    return;
                }
                Thread thread = new Thread(Thread.currentThread().getThreadGroup(), "MediaWiki XML Dump Corpus Populater", (JFileChooser)filer){
                    final /* synthetic */ JFileChooser val$filer;
                    {
                        this.val$filer = jFileChooser;
                        super(x0, x1);
                    }

                    @Override
                    public void run() {
                        try {
                            MediaWikiPopulater.populateCorpus((Corpus)handle.getTarget(), this.val$filer.getSelectedFile().toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
        });
        return actions;
    }

    public static void populateCorpus(final Corpus corpus, URL xml) {
        try {
            model.setUp();
            InputStream in = xml.openStream();
            WikiXMLParser parser = new WikiXMLParser(in, new IArticleFilter(){

                public void process(WikiArticle article, Siteinfo site) throws SAXException {
                    try {
                        FeatureMap features = Factory.newFeatureMap();
                        features.put((Object)"mediawiki.title", (Object)article.getTitle());
                        features.put((Object)"mediawiki.timestamp", (Object)article.getTimeStamp());
                        features.put((Object)"mediawiki.id", (Object)article.getId());
                        features.put((Object)"mediawiki.revision", (Object)article.getRevisionId());
                        features.put((Object)"mediawiki.sitename", (Object)site.getSitename());
                        features.put((Object)"mediawiki.base", (Object)site.getBase());
                        FeatureMap params = Factory.newFeatureMap();
                        params.put((Object)"stringContent", (Object)article.getText());
                        params.put((Object)"mimeType", (Object)"text/x-mediawiki");
                        Document doc = (Document)Factory.createResource((String)"gate.corpora.DocumentImpl", (FeatureMap)params, (FeatureMap)features, (String)article.getTitle());
                        corpus.add((Object)doc);
                        if (corpus.getLRPersistenceId() != null) {
                            corpus.unloadDocument(doc);
                            Factory.deleteResource((Resource)doc);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            parser.parse();
            if (corpus.getDataStore() != null) {
                corpus.getDataStore().sync((LanguageResource)corpus);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            model.tearDown();
        }
    }
}

