/*
 * Decompiled with CFR 0.152.
 */
package uk.bot_by.ijhttp_tools.command_line;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.jetbrains.annotations.NotNull;
import uk.bot_by.ijhttp_tools.command_line.LogLevel;

public class HttpClientCommandLine {
    private static final String HTTP_EXTENSION = ".http";
    private static final String REST_EXTENSION = ".rest";
    private static final BiPredicate<Path, BasicFileAttributes> REQUEST_FILE = (path, basicFileAttributes) -> Files.isRegularFile(path, new LinkOption[0]) && (path.getFileName().toString().endsWith(HTTP_EXTENSION) || path.getFileName().toString().endsWith(REST_EXTENSION));
    private static final String CONNECT_TIMEOUT = "--connect-timeout";
    private static final String DOCKER_MODE = "--docker-mode";
    private static final String ENV = "--env";
    private static final String ENV_FILE = "--env-file";
    private static final String ENV_VARIABLES = "--env-variables";
    private static final String INSECURE = "--insecure";
    private static final String LOG_LEVEL = "--log-level";
    private static final String PRIVATE_ENV_FILE = "--private-env-file";
    private static final String PRIVATE_ENV_VARIABLES = "--private-env-variables";
    private static final String PROXY = "--proxy";
    private static final String REPORT = "--report";
    private static final String SOCKET_TIMEOUT = "--socket-timeout";
    private Integer connectTimeout;
    private Path[] directories = new Path[0];
    private boolean dockerMode;
    private Path environmentFile;
    private List<String> environmentVariables;
    private String environmentName;
    private String executable = "ijhttp";
    private Path[] files = new Path[0];
    private boolean insecure;
    private LogLevel logLevel = LogLevel.BASIC;
    private int maxDepth = Integer.MAX_VALUE;
    private Path privateEnvironmentFile;
    private List<String> privateEnvironmentVariables;
    private String proxy;
    private boolean report;
    private Path reportPath;
    private Integer socketTimeout;

    public void connectTimeout(@NotNull Integer n) {
        this.connectTimeout = n;
    }

    public void directories(Path ... pathArray) {
        this.directories = pathArray;
    }

    public void dockerMode(boolean bl) {
        this.dockerMode = bl;
    }

    public void environmentFile(@NotNull Path path) {
        this.environmentFile = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void environmentVariable(@NotNull String string) {
        HttpClientCommandLine httpClientCommandLine = this;
        synchronized (httpClientCommandLine) {
            if (Objects.isNull(this.environmentVariables)) {
                this.environmentVariables = new ArrayList<String>();
            }
        }
        this.environmentVariables.add(string);
    }

    public void environmentVariables(@NotNull List<String> list) {
        this.environmentVariables = list;
    }

    public void environmentName(@NotNull String string) {
        this.environmentName = string;
    }

    public void executable(@NotNull String string) {
        this.executable = string;
    }

    public void files(Path ... pathArray) {
        this.files = pathArray;
    }

    public void insecure(boolean bl) {
        this.insecure = bl;
    }

    public void logLevel(@NotNull LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void maxDepth(int n) {
        this.maxDepth = n;
    }

    public void privateEnvironmentFile(@NotNull Path path) {
        this.privateEnvironmentFile = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void privateEnvironmentVariable(@NotNull String string) {
        HttpClientCommandLine httpClientCommandLine = this;
        synchronized (httpClientCommandLine) {
            if (Objects.isNull(this.privateEnvironmentVariables)) {
                this.privateEnvironmentVariables = new ArrayList<String>();
            }
        }
        this.privateEnvironmentVariables.add(string);
    }

    public void privateEnvironmentVariables(@NotNull List<String> list) {
        this.privateEnvironmentVariables = list;
    }

    public void proxy(@NotNull String string) {
        this.proxy = string;
    }

    public void report(boolean bl) {
        this.report = bl;
    }

    public void reportPath(@NotNull Path path) {
        this.reportPath = path;
    }

    public void socketTimeout(@NotNull Integer n) {
        this.socketTimeout = n;
    }

    public CommandLine getCommandLine() throws IllegalArgumentException, IOException {
        CommandLine commandLine = new CommandLine(this.executable);
        if (0 == this.files.length && 0 == this.directories.length) {
            throw new IllegalStateException("files are required");
        }
        this.flags(commandLine);
        this.logLevel(commandLine);
        this.timeouts(commandLine);
        this.environmentName(commandLine);
        this.environment(commandLine);
        this.privateEnvironment(commandLine);
        this.proxy(commandLine);
        this.requests(commandLine);
        this.report(commandLine);
        return commandLine;
    }

    private void environment(CommandLine commandLine) throws IOException {
        if (Objects.nonNull(this.environmentFile)) {
            commandLine.addArgument(ENV_FILE).addArgument(this.environmentFile.toString());
        }
        if (Objects.nonNull(this.environmentVariables)) {
            this.environmentVariables.forEach(string -> commandLine.addArgument(ENV_VARIABLES).addArgument(string, false));
        }
    }

    private void environmentName(CommandLine commandLine) {
        if (Objects.nonNull(this.environmentName) && !this.environmentName.isBlank()) {
            commandLine.addArgument(ENV).addArgument(this.environmentName);
        }
    }

    private void flags(CommandLine commandLine) throws IOException {
        if (this.dockerMode) {
            commandLine.addArgument(DOCKER_MODE);
        }
        if (this.insecure) {
            commandLine.addArgument(INSECURE);
        }
    }

    private void logLevel(CommandLine commandLine) {
        switch (this.logLevel) {
            case HEADERS: 
            case VERBOSE: {
                commandLine.addArgument(LOG_LEVEL).addArgument(this.logLevel.name());
            }
        }
    }

    private void privateEnvironment(CommandLine commandLine) throws IOException {
        if (Objects.nonNull(this.privateEnvironmentFile)) {
            commandLine.addArgument(PRIVATE_ENV_FILE).addArgument(this.privateEnvironmentFile.toString());
        }
        if (Objects.nonNull(this.privateEnvironmentVariables)) {
            this.privateEnvironmentVariables.forEach(string -> commandLine.addArgument(PRIVATE_ENV_VARIABLES).addArgument(string, false));
        }
    }

    private void proxy(CommandLine commandLine) {
        if (Objects.nonNull(this.proxy)) {
            commandLine.addArgument(PROXY).addArgument(this.proxy, false);
        }
    }

    private void report(CommandLine commandLine) throws IOException {
        if (this.report) {
            commandLine.addArgument(REPORT);
            if (Objects.nonNull(this.reportPath)) {
                commandLine.addArgument(this.reportPath.toString(), false);
            }
        }
    }

    private void requests(CommandLine commandLine) throws IOException {
        for (Path path : this.files) {
            commandLine.addArgument(path.toString());
        }
        for (Path path : this.directories) {
            try (Stream<Path> stream = Files.find(path, this.maxDepth, REQUEST_FILE, new FileVisitOption[0]);){
                for (Path path2 : stream.toList()) {
                    commandLine.addArgument(path2.toString());
                }
            }
        }
    }

    private void timeouts(CommandLine commandLine) {
        if (Objects.nonNull(this.connectTimeout)) {
            commandLine.addArgument(CONNECT_TIMEOUT).addArgument(this.connectTimeout.toString());
        }
        if (Objects.nonNull(this.socketTimeout)) {
            commandLine.addArgument(SOCKET_TIMEOUT).addArgument(this.socketTimeout.toString());
        }
    }
}

