/*
 * Decompiled with CFR 0.152.
 */
package uk.bot_by.ijhttp_tools.spring_boot_test;

import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import uk.bot_by.ijhttp_tools.command_line.HttpClientCommandLine;
import uk.bot_by.ijhttp_tools.spring_boot_test.HttpClientCommandLineParameters;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={HttpClientCommandLineParameters.class})
public class HttpClientCommandLineConfiguration {
    private final Logger logger = LoggerFactory.getLogger(HttpClientCommandLineConfiguration.class);

    private static void copyBooleanParametersAndLogLevelAndExecutable(HttpClientCommandLineParameters httpClientCommandLineParameters, HttpClientCommandLine httpClientCommandLine) {
        httpClientCommandLine.dockerMode(httpClientCommandLineParameters.isDockerMode());
        httpClientCommandLine.executable(httpClientCommandLineParameters.getExecutable());
        httpClientCommandLine.insecure(httpClientCommandLineParameters.isInsecure());
        httpClientCommandLine.logLevel(httpClientCommandLineParameters.getLogLevel());
        httpClientCommandLine.report(httpClientCommandLineParameters.isReport());
    }

    private static void handleEnvironment(HttpClientCommandLineParameters httpClientCommandLineParameters, HttpClientCommandLine httpClientCommandLine) {
        if (Objects.nonNull(httpClientCommandLineParameters.getEnvironmentFile())) {
            httpClientCommandLine.environmentFile(httpClientCommandLineParameters.getEnvironmentFile());
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getEnvironmentName())) {
            httpClientCommandLine.environmentName(httpClientCommandLineParameters.getEnvironmentName());
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getEnvironmentVariables())) {
            httpClientCommandLine.environmentVariables(httpClientCommandLineParameters.getEnvironmentVariables());
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getPrivateEnvironmentFile())) {
            httpClientCommandLine.privateEnvironmentFile(httpClientCommandLineParameters.getPrivateEnvironmentFile());
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getPrivateEnvironmentVariables())) {
            httpClientCommandLine.privateEnvironmentVariables(httpClientCommandLineParameters.getPrivateEnvironmentVariables());
        }
    }

    private static void handleFileParameters(HttpClientCommandLineParameters httpClientCommandLineParameters, HttpClientCommandLine httpClientCommandLine) {
        if (Objects.nonNull(httpClientCommandLineParameters.getFiles())) {
            httpClientCommandLine.files(httpClientCommandLineParameters.getFiles().toArray(new Path[0]));
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getDirectories())) {
            httpClientCommandLine.directories(httpClientCommandLineParameters.getDirectories().toArray(new Path[0]));
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getReportPath())) {
            httpClientCommandLine.reportPath(httpClientCommandLineParameters.getReportPath());
        }
    }

    private static void handleProxy(HttpClientCommandLineParameters httpClientCommandLineParameters, HttpClientCommandLine httpClientCommandLine) {
        if (Objects.nonNull(httpClientCommandLineParameters.getProxy())) {
            httpClientCommandLine.proxy(httpClientCommandLineParameters.getProxy());
        }
    }

    private static void handleTimeout(HttpClientCommandLineParameters httpClientCommandLineParameters, HttpClientCommandLine httpClientCommandLine) {
        if (Objects.nonNull(httpClientCommandLineParameters.getConnectTimeout())) {
            httpClientCommandLine.connectTimeout(httpClientCommandLineParameters.getConnectTimeout());
        }
        if (Objects.nonNull(httpClientCommandLineParameters.getSocketTimeout())) {
            httpClientCommandLine.socketTimeout(httpClientCommandLineParameters.getSocketTimeout());
        }
    }

    @Bean
    @ConditionalOnMissingBean
    Executor executor(@Value(value="${ijhttp.timeout:-1}") int n) {
        DefaultExecutor defaultExecutor = new DefaultExecutor();
        if (n > 0) {
            defaultExecutor.setWatchdog(new ExecuteWatchdog((long)n));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Set the watchdog (%s) ms", n));
            }
        }
        return defaultExecutor;
    }

    @Bean
    HttpClientCommandLine httpClientCommandLine(HttpClientCommandLineParameters httpClientCommandLineParameters) {
        this.logger.debug("HTTP Client parameters {}", (Object)httpClientCommandLineParameters);
        HttpClientCommandLine httpClientCommandLine = new HttpClientCommandLine();
        HttpClientCommandLineConfiguration.copyBooleanParametersAndLogLevelAndExecutable(httpClientCommandLineParameters, httpClientCommandLine);
        HttpClientCommandLineConfiguration.handleEnvironment(httpClientCommandLineParameters, httpClientCommandLine);
        HttpClientCommandLineConfiguration.handleFileParameters(httpClientCommandLineParameters, httpClientCommandLine);
        HttpClientCommandLineConfiguration.handleProxy(httpClientCommandLineParameters, httpClientCommandLine);
        HttpClientCommandLineConfiguration.handleTimeout(httpClientCommandLineParameters, httpClientCommandLine);
        return httpClientCommandLine;
    }
}

