/*
 * Decompiled with CFR 0.152.
 */
package uk.co.automatictester.wiremock.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import uk.co.automatictester.wiremock.maven.plugin.ConfigurationMojo;
import uk.co.automatictester.wiremock.maven.plugin.WireMockServerRunnerWrapper;

@Mojo(name="run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WireMockMojo
extends ConfigurationMojo {
    public void execute() throws MojoExecutionException {
        this.addRuntimeDependenciesToClasspath();
        String[] rawWireMockParams = this.getAllParams();
        String wireMockParams = this.getFormattedStringFrom(rawWireMockParams);
        String startMessage = String.format("Starting WireMock with following params: %s", wireMockParams);
        this.getLog().info((CharSequence)startMessage);
        WireMockServerRunnerWrapper.run(rawWireMockParams);
        if (this.shouldKeepRunning()) {
            this.keepRunningUntilInterrupted();
        }
    }

    private void addRuntimeDependenciesToClasspath() throws MojoExecutionException {
        ClassRealm realm = this.getDescriptor().getClassRealm();
        for (String classpathElement : this.getClasspathElements()) {
            String message = String.format("Adding %s to wiremock-maven-plugin classpath", classpathElement);
            this.getLog().debug((CharSequence)message);
            URL classpathElementUrl = this.getClasspathElementFrom(classpathElement);
            realm.addURL(classpathElementUrl);
        }
    }

    private URL getClasspathElementFrom(String classpathElement) throws MojoExecutionException {
        File classpathElementFile = new File(classpathElement);
        URI classpathElementUri = classpathElementFile.toURI();
        return this.getClasspathElementFrom(classpathElementUri);
    }

    private URL getClasspathElementFrom(URI uri) throws MojoExecutionException {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Malformed classpath URL", (Exception)e);
        }
    }

    private String getFormattedStringFrom(String[] array) {
        return Arrays.toString(array).replaceAll("[\\[\\]]", "").replaceAll(", ", " ");
    }

    private void keepRunningUntilInterrupted() {
        this.getLog().info((CharSequence)"WireMock will keep running until interrupted manually...");
        while (true) {
            this.sleepForOneSecond();
        }
    }

    private void sleepForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
    }
}

