/*
 * Decompiled with CFR 0.152.
 */
package com.goxr3plus.fxborderlessscene.borderless;

import com.goxr3plus.fxborderlessscene.borderless.Delta;
import com.goxr3plus.fxborderlessscene.window.TransparentWindow;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public class BorderlessController {
    private Stage stage;
    Delta prevSize = new Delta();
    Delta prevPos = new Delta();
    private SimpleBooleanProperty maximized = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty resizable = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty snap = new SimpleBooleanProperty(true);
    private SimpleBooleanProperty doubleClickMaximize = new SimpleBooleanProperty(true);
    private boolean snapped = false;
    @FXML
    private Pane leftPane;
    @FXML
    private Pane rightPane;
    @FXML
    private Pane topPane;
    @FXML
    private Pane bottomPane;
    @FXML
    private Pane topLeftPane;
    @FXML
    private Pane topRightPane;
    @FXML
    private Pane bottomLeftPane;
    @FXML
    private Pane bottomRightPane;
    String bottom = "bottom";
    private TransparentWindow transparentWindow;
    private boolean moving;
    private boolean resizing;

    public void createTransparentWindow(Stage parentWindow) {
        this.transparentWindow = new TransparentWindow();
        this.transparentWindow.getWindow().initOwner((Window)parentWindow);
    }

    public BooleanProperty maximizedProperty() {
        return this.maximized;
    }

    public BooleanProperty resizableProperty() {
        return this.resizable;
    }

    public BooleanProperty snapProperty() {
        return this.snap;
    }

    public BooleanProperty doubleClickMaximizeProperty() {
        return this.doubleClickMaximize;
    }

    @FXML
    private void initialize() {
        this.setResizeControl(this.leftPane, "left");
        this.setResizeControl(this.rightPane, "right");
        this.setResizeControl(this.topPane, "top");
        this.setResizeControl(this.bottomPane, this.bottom);
        this.setResizeControl(this.topLeftPane, "top-left");
        this.setResizeControl(this.topRightPane, "top-right");
        this.setResizeControl(this.bottomLeftPane, this.bottom + "-left");
        this.setResizeControl(this.bottomRightPane, this.bottom + "-right");
        BooleanBinding negateOfResizable = this.resizable.not();
        this.leftPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.rightPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.topPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.bottomPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.topLeftPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.topRightPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.bottomLeftPane.disableProperty().bind((ObservableValue)negateOfResizable);
        this.bottomRightPane.disableProperty().bind((ObservableValue)negateOfResizable);
    }

    protected void setStage(Stage primaryStage) {
        this.stage = primaryStage;
    }

    protected void maximize() {
        Rectangle2D screen;
        try {
            screen = Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)(this.stage.getWidth() / 2.0), (double)(this.stage.getHeight() / 2.0)).isEmpty() ? ((Screen)Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)this.stage.getWidth(), (double)this.stage.getHeight()).get(0)).getVisualBounds() : ((Screen)Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)(this.stage.getWidth() / 2.0), (double)(this.stage.getHeight() / 2.0)).get(0)).getVisualBounds();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (this.maximized.get()) {
            this.stage.setWidth(this.prevSize.x.doubleValue());
            this.stage.setHeight(this.prevSize.y.doubleValue());
            this.stage.setX(this.prevPos.x.doubleValue());
            this.stage.setY(this.prevPos.y.doubleValue());
            this.setMaximized(false);
        } else {
            if (!this.snapped) {
                this.prevSize.x = this.stage.getWidth();
                this.prevSize.y = this.stage.getHeight();
                this.prevPos.x = this.stage.getX();
                this.prevPos.y = this.stage.getY();
            } else if (!screen.contains(this.prevPos.x.doubleValue(), this.prevPos.y.doubleValue())) {
                if (this.prevSize.x > screen.getWidth()) {
                    this.prevSize.x = screen.getWidth() - 20.0;
                }
                if (this.prevSize.y > screen.getHeight()) {
                    this.prevSize.y = screen.getHeight() - 20.0;
                }
                this.prevPos.x = screen.getMinX() + (screen.getWidth() - this.prevSize.x) / 2.0;
                this.prevPos.y = screen.getMinY() + (screen.getHeight() - this.prevSize.y) / 2.0;
            }
            this.stage.setX(screen.getMinX());
            this.stage.setY(screen.getMinY());
            this.stage.setWidth(screen.getWidth());
            this.stage.setHeight(screen.getHeight());
            this.setMaximized(true);
        }
    }

    protected void minimize() {
        this.stage.setIconified(true);
    }

    protected void setMoveControl(Node node) {
        Delta delta = new Delta();
        Delta eventSource = new Delta();
        node.setOnMousePressed(m -> {
            if (m.isPrimaryButtonDown() && !this.resizing) {
                delta.x = m.getSceneX();
                delta.y = m.getSceneY();
                if (this.maximized.get() || this.snapped) {
                    delta.x = this.prevSize.x * (m.getSceneX() / this.stage.getWidth());
                    delta.y = this.prevSize.y * (m.getSceneY() / this.stage.getHeight());
                } else {
                    this.prevSize.x = this.stage.getWidth();
                    this.prevSize.y = this.stage.getHeight();
                    this.prevPos.x = this.stage.getX();
                    this.prevPos.y = this.stage.getY();
                }
                eventSource.x = m.getScreenX();
                eventSource.y = node.prefHeight(this.stage.getHeight());
                this.moving = true;
            }
        });
        node.setOnMouseDragged(m -> {
            if (m.isPrimaryButtonDown() && this.moving) {
                if (delta.x != null) {
                    this.stage.setX(m.getScreenX() - delta.x);
                }
                if (this.snapped) {
                    if (m.getScreenY() > eventSource.y) {
                        this.snapOff();
                    } else {
                        Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)m.getScreenX(), (double)m.getScreenY(), (double)1.0, (double)1.0).get(0)).getVisualBounds();
                        this.stage.setHeight(screen.getHeight());
                    }
                } else if (delta.y != null) {
                    this.stage.setY(m.getScreenY() - delta.y);
                }
                if (this.maximized.get()) {
                    this.stage.setWidth(this.prevSize.x.doubleValue());
                    this.stage.setHeight(this.prevSize.y.doubleValue());
                    this.setMaximized(false);
                }
                boolean toCloseWindow = false;
                if (!this.snap.get()) {
                    toCloseWindow = true;
                } else {
                    ObservableList screens = Screen.getScreensForRectangle((double)m.getScreenX(), (double)m.getScreenY(), (double)1.0, (double)1.0);
                    if (screens.isEmpty()) {
                        return;
                    }
                    Rectangle2D screen = ((Screen)screens.get(0)).getVisualBounds();
                    if (m.getScreenX() <= screen.getMinX()) {
                        this.transparentWindow.getWindow().setY(screen.getMinY());
                        this.transparentWindow.getWindow().setHeight(screen.getHeight());
                        this.transparentWindow.getWindow().setX(screen.getMinX());
                        if (screen.getWidth() / 2.0 < this.transparentWindow.getWindow().getMinWidth()) {
                            this.transparentWindow.getWindow().setWidth(this.transparentWindow.getWindow().getMinWidth());
                        } else {
                            this.transparentWindow.getWindow().setWidth(screen.getWidth() / 2.0);
                        }
                        this.transparentWindow.show();
                    } else if (m.getScreenX() >= screen.getMaxX() - 1.0) {
                        this.transparentWindow.getWindow().setY(screen.getMinY());
                        this.transparentWindow.getWindow().setHeight(screen.getHeight());
                        if (screen.getWidth() / 2.0 < this.transparentWindow.getWindow().getMinWidth()) {
                            this.transparentWindow.getWindow().setWidth(this.transparentWindow.getWindow().getMinWidth());
                        } else {
                            this.transparentWindow.getWindow().setWidth(screen.getWidth() / 2.0);
                        }
                        this.transparentWindow.getWindow().setX(screen.getMaxX() - this.transparentWindow.getWindow().getWidth());
                        this.transparentWindow.show();
                    } else if (m.getScreenY() <= screen.getMinY() || m.getScreenY() >= screen.getMaxY() - 1.0) {
                        this.transparentWindow.getWindow().setX(screen.getMinX());
                        this.transparentWindow.getWindow().setY(screen.getMinY());
                        this.transparentWindow.getWindow().setWidth(screen.getWidth());
                        this.transparentWindow.getWindow().setHeight(screen.getHeight());
                        this.transparentWindow.show();
                    } else {
                        toCloseWindow = true;
                    }
                }
                if (toCloseWindow) {
                    this.transparentWindow.close();
                }
            }
        });
        node.setOnMouseClicked(m -> {
            if (this.doubleClickMaximize.get() && MouseButton.PRIMARY.equals((Object)m.getButton()) && m.getClickCount() == 2) {
                this.maximize();
            }
            this.moving = false;
            this.resizing = false;
        });
        node.setOnMouseReleased(m -> {
            try {
                if (!this.moving || !this.snap.get()) {
                    return;
                }
                this.moving = false;
                this.resizing = false;
                if (!this.snap.get()) {
                    return;
                }
                if (MouseButton.PRIMARY.equals((Object)m.getButton()) && m.getScreenX() != eventSource.x.doubleValue()) {
                    Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)m.getScreenX(), (double)m.getScreenY(), (double)1.0, (double)1.0).get(0)).getVisualBounds();
                    if (m.getScreenX() <= screen.getMinX()) {
                        this.stage.setY(screen.getMinY());
                        this.stage.setHeight(screen.getHeight());
                        this.stage.setX(screen.getMinX());
                        if (screen.getWidth() / 2.0 < this.stage.getMinWidth()) {
                            this.stage.setWidth(this.stage.getMinWidth());
                        } else {
                            this.stage.setWidth(screen.getWidth() / 2.0);
                        }
                        this.snapped = true;
                    } else if (m.getScreenX() >= screen.getMaxX() - 1.0) {
                        this.stage.setY(screen.getMinY());
                        this.stage.setHeight(screen.getHeight());
                        if (screen.getWidth() / 2.0 < this.stage.getMinWidth()) {
                            this.stage.setWidth(this.stage.getMinWidth());
                        } else {
                            this.stage.setWidth(screen.getWidth() / 2.0);
                        }
                        this.stage.setX(screen.getMaxX() - this.stage.getWidth());
                        this.snapped = true;
                    } else if (m.getScreenY() <= screen.getMinY() || m.getScreenY() >= screen.getMaxY() - 1.0) {
                        if (!screen.contains(this.prevPos.x.doubleValue(), this.prevPos.y.doubleValue())) {
                            if (this.prevSize.x > screen.getWidth()) {
                                this.prevSize.x = screen.getWidth() - 20.0;
                            }
                            if (this.prevSize.y > screen.getHeight()) {
                                this.prevSize.y = screen.getHeight() - 20.0;
                            }
                            this.prevPos.x = screen.getMinX() + (screen.getWidth() - this.prevSize.x) / 2.0;
                            this.prevPos.y = screen.getMinY() + (screen.getHeight() - this.prevSize.y) / 2.0;
                        }
                        this.stage.setX(screen.getMinX());
                        this.stage.setY(screen.getMinY());
                        this.stage.setWidth(screen.getWidth());
                        this.stage.setHeight(screen.getHeight());
                        this.setMaximized(true);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.transparentWindow.close();
        });
    }

    private void snapOff() {
        this.stage.setWidth(this.prevSize.x.doubleValue());
        this.stage.setHeight(this.prevSize.y.doubleValue());
        this.snapped = false;
    }

    private void setResizeControl(Pane pane, String direction) {
        pane.setOnDragDetected(event -> {
            this.prevSize.x = this.stage.getWidth();
            this.prevSize.y = this.stage.getHeight();
            this.prevPos.x = this.stage.getX();
            this.prevPos.y = this.stage.getY();
            this.moving = true;
        });
        pane.setOnMouseDragged(m -> {
            if (m.isPrimaryButtonDown() && this.moving) {
                double comingWidth;
                double width = this.stage.getWidth();
                double height = this.stage.getHeight();
                if (direction.endsWith("left")) {
                    comingWidth = width - m.getScreenX() + this.stage.getX();
                    if (comingWidth > 0.0 && comingWidth >= this.stage.getMinWidth()) {
                        this.stage.setWidth(this.stage.getX() - m.getScreenX() + this.stage.getWidth());
                        this.stage.setX(m.getScreenX());
                    }
                } else if (direction.endsWith("right") && (comingWidth = width + m.getX()) > 0.0 && comingWidth >= this.stage.getMinWidth()) {
                    this.stage.setWidth(m.getSceneX());
                }
                if (direction.startsWith("top")) {
                    if (this.snapped) {
                        this.stage.setHeight(this.prevSize.y.doubleValue());
                        this.snapped = false;
                    } else if (height > this.stage.getMinHeight() || m.getY() < 0.0) {
                        this.stage.setHeight(this.stage.getY() - m.getScreenY() + this.stage.getHeight());
                        this.stage.setY(m.getScreenY());
                    }
                } else if (direction.startsWith(this.bottom)) {
                    if (this.snapped) {
                        this.stage.setY(this.prevPos.y.doubleValue());
                        this.snapped = false;
                    } else {
                        double comingHeight = height + m.getY();
                        if (comingHeight > 0.0 && comingHeight >= this.stage.getMinHeight()) {
                            this.stage.setHeight(m.getSceneY());
                        }
                    }
                }
            }
        });
        pane.setOnMousePressed(m -> {
            if (m.isPrimaryButtonDown() && !this.snapped && !this.moving) {
                this.resizing = true;
                this.prevSize.y = this.stage.getHeight();
                this.prevPos.y = this.stage.getY();
            }
        });
        pane.setOnMouseReleased(m -> {
            if (this.resizing && MouseButton.PRIMARY.equals((Object)m.getButton()) && !this.snapped) {
                Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)m.getScreenX(), (double)m.getScreenY(), (double)1.0, (double)1.0).get(0)).getVisualBounds();
                if (this.stage.getY() <= screen.getMinY() && direction.startsWith("top")) {
                    this.stage.setHeight(screen.getHeight());
                    this.stage.setY(screen.getMinY());
                    this.snapped = true;
                }
                if (m.getScreenY() >= screen.getMaxY() && direction.startsWith(this.bottom)) {
                    this.stage.setHeight(screen.getHeight());
                    this.stage.setY(screen.getMinY());
                    this.snapped = true;
                }
            }
            this.resizing = false;
            this.moving = false;
        });
        pane.setOnMouseClicked(m -> {
            if (MouseButton.PRIMARY.equals((Object)m.getButton()) && m.getClickCount() == 2 && ("top".equals(direction) || this.bottom.equals(direction))) {
                Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)(this.stage.getWidth() / 2.0), (double)(this.stage.getHeight() / 2.0)).get(0)).getVisualBounds();
                if (this.snapped) {
                    this.stage.setHeight(this.prevSize.y.doubleValue());
                    this.stage.setY(this.prevPos.y.doubleValue());
                    this.snapped = false;
                } else {
                    this.prevSize.y = this.stage.getHeight();
                    this.prevPos.y = this.stage.getY();
                    this.stage.setHeight(screen.getHeight());
                    this.stage.setY(screen.getMinY());
                    this.snapped = true;
                }
            }
        });
    }

    private void setMaximized(boolean maximized) {
        this.maximized.set(maximized);
        this.setResizable(!maximized);
    }

    protected void setResizable(boolean bool) {
        this.resizable.set(bool);
    }

    protected void setSnapEnabled(boolean bool) {
        this.snap.set(bool);
        if (!bool && this.snapped) {
            this.snapOff();
        }
    }

    protected void setDoubleClickMaximizeEnabled(boolean bool) {
        this.doubleClickMaximize.set(bool);
    }

    public TransparentWindow getTransparentWindow() {
        return this.transparentWindow;
    }
}

