/*
 * Decompiled with CFR 0.152.
 */
package uk.co.bssd.jmx;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import uk.co.bssd.jmx.JmxException;
import uk.co.bssd.jmx.ManagementAttribute;

public class ManagementBean {
    private final MBeanServerConnection beanServerConnection;
    private final ObjectName objectName;

    public ManagementBean(MBeanServerConnection connection, ObjectName objectName) {
        this.beanServerConnection = connection;
        this.objectName = objectName;
    }

    public <T> ManagementAttribute<T> findAttribute(String name, Class<T> attributeClazz) {
        if (!this.hasAttribute(name)) {
            throw new JmxException("Attribute [" + name + "] does not exist for object [" + this.objectName + "]");
        }
        return new ManagementAttribute(this.beanServerConnection, this.objectName, name);
    }

    public boolean hasAttribute(String name) {
        for (MBeanAttributeInfo attribute : this.listAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private MBeanAttributeInfo[] listAttributes() {
        return this.mbeanInfo().getAttributes();
    }

    private MBeanInfo mbeanInfo() {
        try {
            return this.beanServerConnection.getMBeanInfo(this.objectName);
        }
        catch (Exception e) {
            throw new JmxException("Unable to get MBeanInfo for ObjectName: " + this.objectName, e);
        }
    }
}

