/*
 * Decompiled with CFR 0.152.
 */
package uk.co.bssd.jmx;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import uk.co.bssd.jmx.JmxException;
import uk.co.bssd.jmx.ManagementBean;
import uk.co.bssd.jmx.ObjectNameFactory;
import uk.co.bssd.jmx.ProcessManagementBean;

public class ManagementBeanServer {
    private final MBeanServerConnection connection;

    public ManagementBeanServer(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public ManagementBean findManagementBean(String name) {
        ObjectName objectName = ObjectNameFactory.objectName(name);
        if (!this.isRegistered(objectName)) {
            throw new JmxException("No bean registered with name [" + name + "]");
        }
        return new ManagementBean(this.connection, objectName);
    }

    public ProcessManagementBean processManagementBean() {
        return new ProcessManagementBean(this.connection);
    }

    private boolean isRegistered(ObjectName objectName) {
        try {
            return this.connection.isRegistered(objectName);
        }
        catch (IOException e) {
            throw new JmxException("Unable to check if bean is registered", e);
        }
    }
}

