/*
 * Decompiled with CFR 0.152.
 */
package uk.co.bssd.jmx;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import javax.management.MBeanServerConnection;

public class ProcessManagementBean {
    private final OperatingSystemMXBean operatingSystemBean;
    private final MemoryMXBean memoryBean;
    private final int availableProcessors;
    private long lastSystemTime;
    private long lastProcessCpuTime;

    public ProcessManagementBean(MBeanServerConnection connection) {
        this.operatingSystemBean = this.operatingSystemBean(connection);
        this.memoryBean = this.memoryBean(connection);
        this.availableProcessors = this.operatingSystemBean.getAvailableProcessors();
        this.lastSystemTime = System.nanoTime();
        this.lastProcessCpuTime = this.operatingSystemBean.getProcessCpuTime();
    }

    public long heapMemoryMax() {
        return this.memoryBean.getHeapMemoryUsage().getMax();
    }

    public long heapMemoryUsed() {
        return this.memoryBean.getHeapMemoryUsage().getUsed();
    }

    public double heapMemoryPercentageUsed() {
        return this.heapMemoryUsed() * 100L / this.heapMemoryMax();
    }

    public double cpuUsage() {
        long systemTime = System.nanoTime();
        long processCpuTime = this.operatingSystemBean.getProcessCpuTime();
        double cpuUsage = 100L * (processCpuTime - this.lastProcessCpuTime) / (systemTime - this.lastSystemTime);
        this.lastSystemTime = systemTime;
        this.lastProcessCpuTime = processCpuTime;
        return Math.min(100.0, cpuUsage / (double)this.availableProcessors);
    }

    private MemoryMXBean memoryBean(MBeanServerConnection connection) {
        return this.platformBean(connection, "java.lang:type=Memory", MemoryMXBean.class);
    }

    private OperatingSystemMXBean operatingSystemBean(MBeanServerConnection connection) {
        return this.platformBean(connection, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
    }

    private <T> T platformBean(MBeanServerConnection connection, String beanName, Class<T> clazz) {
        try {
            return ManagementFactory.newPlatformMXBeanProxy(connection, beanName, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get OperatingSystemMXBean", e);
        }
    }
}

