/*
 * Decompiled with CFR 0.152.
 */
package uk.co.bssd.jmx;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import uk.co.bssd.jmx.JmxException;
import uk.co.bssd.jmx.ManagementBeanServer;

public final class RemoteManagementBeanServerFactory {
    private RemoteManagementBeanServerFactory() {
    }

    public static ManagementBeanServer managementBeanServer(String hostname, int port) {
        String url = RemoteManagementBeanServerFactory.connectionUrl(hostname, port);
        MBeanServerConnection connection = RemoteManagementBeanServerFactory.mbeanServerConnection(url);
        return new ManagementBeanServer(connection);
    }

    private static MBeanServerConnection mbeanServerConnection(String url) {
        try {
            JMXServiceURL jmxServiceUrl = new JMXServiceURL(url);
            JMXConnector jmxConnector = JMXConnectorFactory.connect(jmxServiceUrl);
            return jmxConnector.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new JmxException("Unable to obtain connection to url '" + url + "'", e);
        }
    }

    private static String connectionUrl(String hostname, int port) {
        return String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", hostname, port);
    }
}

