/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcjinfo;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.co.caprica.vlcjinfo.Duration;

final class Conversions {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("(\\-?[\\d\\s]+)(?:\\s?\\w+)?");
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("(\\d+\\.\\d+)(?: \\w+)?");
    private static final Pattern DURATION_PATTERN_1 = Pattern.compile("(?:(\\d{2}):(\\d{2}):(\\d{2})\\.(\\d{3}))(\\s.*)?");
    private static final Pattern DURATION_PATTERN_2 = Pattern.compile("(?:(\\-?\\d+)\\s*h)?\\s*(?:(\\-?\\d+)\\s*m(?:in)?)?\\s*(?:(\\-?\\d+)\\s*s)?\\s*(?:(\\-?\\d+)\\s*ms)?");

    private Conversions() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Integer integer(String value) {
        if (value == null) return null;
        Matcher matcher = INTEGER_PATTERN.matcher(value = value.trim());
        if (!matcher.matches()) throw new IllegalArgumentException("Unknown format for value: " + value);
        return Integer.parseInt(matcher.group(1).replace(" ", ""));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BigDecimal decimal(String value) {
        if (value == null) return null;
        Matcher matcher = DECIMAL_PATTERN.matcher(value = value.trim());
        if (!matcher.matches()) throw new IllegalArgumentException("Unknown format for value: " + value);
        return new BigDecimal(matcher.group(1));
    }

    static Duration duration(String value) {
        if (value != null) {
            Duration duration = Conversions.tryDuration(value = value.trim(), DURATION_PATTERN_1);
            if (duration != null) {
                return duration;
            }
            duration = Conversions.tryDuration(value, DURATION_PATTERN_2);
            if (duration != null) {
                return duration;
            }
            throw new IllegalArgumentException("Unknown format for value: " + value);
        }
        return null;
    }

    private static Duration tryDuration(String value, Pattern pattern) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            int hours = matcher.group(1) != null ? Integer.parseInt(matcher.group(1)) : 0;
            int minutes = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 0;
            int seconds = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
            int millis = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
            return new Duration(hours, minutes, seconds, millis);
        }
        return null;
    }
}

