/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcjinfo;

import uk.co.caprica.vlcjinfo.Conversions;

public final class Duration {
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int millis;

    public static Duration duration(String value) {
        return Conversions.duration(value);
    }

    public Duration(int hours, int minutes, int seconds, int millis) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.millis = millis;
    }

    public int hours() {
        return this.hours;
    }

    public int minutes() {
        return this.minutes;
    }

    public int seconds() {
        return this.seconds;
    }

    public int millis() {
        return this.millis;
    }

    public long asMilliSeconds() {
        return ((this.hours * 60 + this.minutes) * 60 + this.seconds) * 1000 + this.millis;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("hours=").append(this.hours).append(',');
        sb.append("minutes=").append(this.minutes).append(',');
        sb.append("seconds=").append(this.seconds).append(',');
        sb.append("millis=").append(this.millis).append(',');
        sb.append("asMilliSeconds=").append(this.asMilliSeconds()).append(']');
        return sb.toString();
    }
}

