/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcjinfo;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.co.caprica.vlcjinfo.Parser;
import uk.co.caprica.vlcjinfo.Section;
import uk.co.caprica.vlcjinfo.Sections;
import uk.co.caprica.vlcjinfo.binding.LibMediaInfo;

public final class MediaInfo {
    private final Map<String, Sections> sectionsByType = new LinkedHashMap<String, Sections>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaInfo mediaInfo(String filename) {
        MediaInfo result;
        LibMediaInfo lib = LibMediaInfo.INSTANCE;
        Pointer handle = lib.MediaInfo_New();
        if (handle != null) {
            try {
                int opened = lib.MediaInfo_Open(handle, new WString(filename));
                if (opened == 1) {
                    lib.MediaInfo_Option(handle, new WString("Inform"), new WString(""));
                    lib.MediaInfo_Option(handle, new WString("Complete"), new WString("1"));
                    WString data = lib.MediaInfo_Inform(handle);
                    lib.MediaInfo_Close(handle);
                    result = new Parser(data.toString()).parse();
                }
                result = null;
            }
            finally {
                lib.MediaInfo_Delete(handle);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Sections sections(String type) {
        Sections result = this.sectionsByType.get(type);
        if (result == null) {
            result = new Sections();
            this.sectionsByType.put(type, result);
        }
        return result;
    }

    public Section first(String type) {
        Sections sections = this.sections(type);
        Section result = sections != null ? sections.first() : null;
        return result;
    }

    public void dump(Writer writer) {
        PrintWriter printer = new PrintWriter(writer);
        for (String sectionType : this.sectionsByType.keySet()) {
            int sectionNumber = 0;
            for (Section section : this.sectionsByType.get(sectionType)) {
                printer.printf("%s [%d]%n", sectionType, sectionNumber++);
                for (String key : section) {
                    printer.printf(" %35s -> %s%n", key, section.value(key));
                }
            }
            printer.println();
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("sectionsByType=").append(this.sectionsByType).append(']');
        return sb.toString();
    }
}

