/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcjinfo;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.File;
import uk.co.caprica.vlcjinfo.binding.LibMediaInfo;

public final class MediaInfoFile {
    private final String filename;
    private Pointer handle;

    public MediaInfoFile(File file) {
        this(file.getAbsolutePath());
    }

    public MediaInfoFile(String filename) {
        this.filename = filename;
    }

    public boolean open() {
        LibMediaInfo lib = LibMediaInfo.INSTANCE;
        this.handle = lib.MediaInfo_New();
        if (this.handle != null) {
            int opened = lib.MediaInfo_Open(this.handle, new WString(this.filename));
            if (opened == 1) {
                return true;
            }
            lib.MediaInfo_Delete(this.handle);
        }
        return false;
    }

    public String info(String value) {
        LibMediaInfo.INSTANCE.MediaInfo_Option(null, new WString("Inform"), new WString(value));
        WString result = LibMediaInfo.INSTANCE.MediaInfo_Inform(this.handle);
        return result != null ? result.toString() : null;
    }

    public void close() {
        if (this.handle != null) {
            LibMediaInfo.INSTANCE.MediaInfo_Close(this.handle);
            LibMediaInfo.INSTANCE.MediaInfo_Delete(this.handle);
        }
    }
}

