/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcjinfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import uk.co.caprica.vlcjinfo.MediaInfo;
import uk.co.caprica.vlcjinfo.MediaInfoParseException;
import uk.co.caprica.vlcjinfo.Section;
import uk.co.caprica.vlcjinfo.Sections;

final class Parser {
    private final String data;
    private ParseState parseState = ParseState.DEFAULT;

    Parser(String data) {
        this.data = data;
    }

    MediaInfo parse() {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(this.data));
            MediaInfo mediaInfo = new MediaInfo();
            Section section = null;
            block7: while (this.parseState != ParseState.FINISHED) {
                switch (this.parseState) {
                    case DEFAULT: {
                        this.parseState = ParseState.NEXT_SECTION;
                        continue block7;
                    }
                    case NEXT_SECTION: {
                        String sectionName = reader.readLine();
                        if (sectionName == null) {
                            this.parseState = ParseState.FINISHED;
                            continue block7;
                        }
                        if (sectionName.length() <= 0) continue block7;
                        this.parseState = ParseState.SECTION;
                        Sections sections = mediaInfo.sections(sectionName);
                        section = sections.newSection();
                        continue block7;
                    }
                    case SECTION: {
                        String line = reader.readLine();
                        if (line == null) {
                            this.parseState = ParseState.FINISHED;
                            continue block7;
                        }
                        if (line.length() == 0) {
                            this.parseState = ParseState.NEXT_SECTION;
                            continue block7;
                        }
                        String[] values = line.split(":", 2);
                        section.put(values[0].trim(), values[1].trim());
                        continue block7;
                    }
                }
                throw new IllegalStateException();
            }
            return mediaInfo;
        }
        catch (IOException e) {
            throw new MediaInfoParseException("Failed to parse media info", e);
        }
    }

    private static enum ParseState {
        DEFAULT,
        NEXT_SECTION,
        SECTION,
        FINISHED;

    }
}

