/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.javafx.view;

import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;

public class ResizableImageView
extends Pane {
    protected final ImageView imageView;
    private double previousWidth = -1.0;
    private double previousHeight = -1.0;

    public ResizableImageView(ImageView imageView) {
        this.imageView = imageView;
        this.getChildren().add((Object)imageView);
        imageView.imageProperty().addListener(this::imageChanged);
        imageView.fitWidthProperty().addListener(this::sizeChanged);
        imageView.fitHeightProperty().addListener(this::sizeChanged);
    }

    private void imageChanged(ObservableValue<? extends Image> observableValue, Image oldValue, Image newValue) {
        this.previousHeight = -1.0;
        this.previousWidth = -1.0;
        this.update();
    }

    private void sizeChanged(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
        this.update();
    }

    private void update() {
        Image image = this.imageView.getImage();
        if (image != null) {
            this.onNewSize();
        }
    }

    protected final void layoutChildren() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (this.previousWidth == width && this.previousHeight == height) {
            return;
        }
        this.previousWidth = width;
        this.previousHeight = height;
        this.imageView.setFitWidth(width);
        this.imageView.setFitHeight(height);
        this.layoutInArea((Node)this.imageView, 0.0, 0.0, width, height, 0.0, HPos.CENTER, VPos.CENTER);
        super.layoutChildren();
    }

    protected void onNewSize() {
    }
}

