/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Native;
import java.util.Collection;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LinuxNativeInit;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.factory.ApplicationApi;
import uk.co.caprica.vlcj.factory.AudioApi;
import uk.co.caprica.vlcj.factory.DialogsApi;
import uk.co.caprica.vlcj.factory.EqualizerApi;
import uk.co.caprica.vlcj.factory.MediaApi;
import uk.co.caprica.vlcj.factory.MediaDiscovererApi;
import uk.co.caprica.vlcj.factory.MediaPlayerApi;
import uk.co.caprica.vlcj.factory.NativeLibraryPath;
import uk.co.caprica.vlcj.factory.RendererApi;
import uk.co.caprica.vlcj.factory.VideoSurfaceApi;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.support.eventmanager.TaskExecutor;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

public class MediaPlayerFactory {
    protected final LibVlc libvlc;
    protected final libvlc_instance_t libvlcInstance;
    private final TaskExecutor executor = new TaskExecutor();
    private final ApplicationApi applicationApi;
    private final AudioApi audioApi;
    private final DialogsApi dialogsApi;
    private final MediaDiscovererApi mediaDiscovererApi;
    private final EqualizerApi equalizerApi;
    private final MediaPlayerApi mediaPlayerApi;
    private final MediaApi mediaApi;
    private final RendererApi rendererApi;
    private final VideoSurfaceApi videoSurfaceApi;

    public MediaPlayerFactory(NativeDiscovery discovery, String ... libvlcArgs) {
        this.libvlc = this.discoverNativeLibrary(discovery);
        this.libvlcInstance = this.newLibVlcInstance(libvlcArgs != null ? libvlcArgs : new String[]{});
        this.applicationApi = new ApplicationApi(this);
        this.audioApi = new AudioApi(this);
        this.dialogsApi = new DialogsApi(this);
        this.mediaDiscovererApi = new MediaDiscovererApi(this);
        this.equalizerApi = new EqualizerApi(this);
        this.mediaPlayerApi = new MediaPlayerApi(this);
        this.mediaApi = new MediaApi(this);
        this.rendererApi = new RendererApi(this);
        this.videoSurfaceApi = new VideoSurfaceApi(this);
    }

    public MediaPlayerFactory(String ... libvlcArgs) {
        this(new NativeDiscovery(new NativeDiscoveryStrategy[0]), libvlcArgs);
    }

    public MediaPlayerFactory(NativeDiscovery discovery, Collection<String> libvlcArgs) {
        this(discovery, libvlcArgs.toArray(new String[libvlcArgs.size()]));
    }

    public MediaPlayerFactory(Collection<String> libvlcArgs) {
        this(new NativeDiscovery(new NativeDiscoveryStrategy[0]), libvlcArgs);
    }

    public MediaPlayerFactory() {
        this(new NativeDiscovery(new NativeDiscoveryStrategy[0]), new String[0]);
    }

    private LibVlc discoverNativeLibrary(NativeDiscovery discovery) {
        if (discovery != null) {
            discovery.discover();
        }
        LibVlc nativeLibrary = (LibVlc)Native.load((String)RuntimeUtil.getLibVlcLibraryName(), LibVlc.class);
        this.checkVersion(nativeLibrary);
        return nativeLibrary;
    }

    private void checkVersion(LibVlc nativeLibrary) {
        LibVlcVersion version = new LibVlcVersion(nativeLibrary);
        if (!version.isSupported()) {
            throw new RuntimeException(String.format("Failed to find minimum required VLC version %s, found %s in %s", version.getRequiredVersion(), version.getVersion(), NativeLibraryPath.getNativeLibraryPath(nativeLibrary)));
        }
    }

    private libvlc_instance_t newLibVlcInstance(String ... libvlcArgs) {
        libvlc_instance_t result = this.libvlc.libvlc_new(libvlcArgs.length, libvlcArgs);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Failed to get a new native library instance");
    }

    public final ApplicationApi application() {
        return this.applicationApi;
    }

    public final AudioApi audio() {
        return this.audioApi;
    }

    public final DialogsApi dialogs() {
        return this.dialogsApi;
    }

    public final MediaDiscovererApi mediaDiscoverers() {
        return this.mediaDiscovererApi;
    }

    public final EqualizerApi equalizer() {
        return this.equalizerApi;
    }

    public final MediaPlayerApi mediaPlayers() {
        return this.mediaPlayerApi;
    }

    public final MediaApi media() {
        return this.mediaApi;
    }

    public final RendererApi renderers() {
        return this.rendererApi;
    }

    public final VideoSurfaceApi videoSurfaces() {
        return this.videoSurfaceApi;
    }

    public final void submit(Runnable r) {
        this.executor.submit(r);
    }

    public final String nativeLibraryPath() {
        return NativeLibraryPath.getNativeLibraryPath(this.libvlc);
    }

    public final void release() {
        this.executor.release();
        this.onBeforeRelease();
        this.applicationApi.release();
        this.audioApi.release();
        this.dialogsApi.release();
        this.mediaDiscovererApi.release();
        this.equalizerApi.release();
        this.mediaPlayerApi.release();
        this.mediaApi.release();
        this.rendererApi.release();
        this.videoSurfaceApi.release();
        this.libvlc.libvlc_release(this.libvlcInstance);
        this.onAfterRelease();
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    static {
        if (RuntimeUtil.isNix()) {
            LinuxNativeInit.init();
        }
    }
}

