/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.factory.discovery.strategy.LinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.OsxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.WindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

public class NativeDiscovery {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private boolean alreadyFound;
    private static final NativeDiscoveryStrategy[] DEFAULT_STRATEGIES = new NativeDiscoveryStrategy[]{new LinuxNativeDiscoveryStrategy(), new OsxNativeDiscoveryStrategy(), new WindowsNativeDiscoveryStrategy()};
    private final NativeDiscoveryStrategy[] discoveryStrategies;

    public NativeDiscovery(NativeDiscoveryStrategy ... discoveryStrategies) {
        this.discoveryStrategies = discoveryStrategies.length > 0 ? discoveryStrategies : DEFAULT_STRATEGIES;
    }

    public final boolean discover() {
        if (this.alreadyFound) {
            return true;
        }
        for (NativeDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
            String path;
            if (!discoveryStrategy.supported() || (path = discoveryStrategy.discover()) == null) continue;
            if (discoveryStrategy.onFound(path)) {
                NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)path);
            }
            this.tryPluginPath(path, discoveryStrategy);
            if (this.tryLoadingLibrary()) {
                this.onFound(path, discoveryStrategy);
                this.alreadyFound = true;
                return true;
            }
            this.onFailed(path, discoveryStrategy);
            return false;
        }
        this.onNotFound();
        return false;
    }

    private void tryPluginPath(String path, NativeDiscoveryStrategy discoveryStrategy) {
        String env = System.getenv(PLUGIN_ENV_NAME);
        if (env == null || env.length() == 0) {
            discoveryStrategy.onSetPluginPath(path);
        }
    }

    private boolean tryLoadingLibrary() {
        try {
            LibVlc libvlc = (LibVlc)Native.load((String)RuntimeUtil.getLibVlcLibraryName(), LibVlc.class);
            libvlc_instance_t instance = libvlc.libvlc_new(0, new String[0]);
            if (instance != null) {
                libvlc.libvlc_release(instance);
                LibVlcVersion version = new LibVlcVersion(libvlc);
                if (version.isSupported()) {
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return false;
    }

    protected void onFound(String path, NativeDiscoveryStrategy strategy) {
    }

    protected void onFailed(String path, NativeDiscoveryStrategy strategy) {
    }

    protected void onNotFound() {
    }
}

