/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaOptions;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.MediaResourceLocator;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;

public final class MediaFactory {
    private MediaFactory() {
    }

    public static MediaRef newMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        MediaRef result = MediaFactory.createMediaRef(libvlc, libvlcInstance, mediaInstance, options);
        if (result != null) {
            libvlc.libvlc_media_retain(mediaInstance);
        }
        return result;
    }

    public static MediaRef newMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, String mrl, String ... options) {
        return MediaFactory.createMediaRef(libvlc, libvlcInstance, MediaFactory.newMediaInstance(libvlc, libvlcInstance, mrl), options);
    }

    public static MediaRef newMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia, String ... options) {
        return MediaFactory.createMediaRef(libvlc, libvlcInstance, MediaFactory.newMediaInstance(libvlc, libvlcInstance, callbackMedia), options);
    }

    public static MediaRef newMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMediaRef(libvlc, libvlcInstance, MediaFactory.retain(libvlc, media.mediaInstance()), options);
    }

    public static MediaRef newMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMediaRef(libvlc, libvlcInstance, MediaFactory.retain(libvlc, mediaRef.mediaInstance()), options);
    }

    public static MediaRef duplicateMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMediaRef(libvlc, libvlcInstance, libvlc.libvlc_media_duplicate(mediaRef.mediaInstance()), options);
    }

    public static Media newMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        Media result = MediaFactory.createMedia(libvlc, libvlcInstance, mediaInstance, options);
        if (result != null) {
            libvlc.libvlc_media_retain(mediaInstance);
        }
        return result;
    }

    public static Media newMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, String mrl, String ... options) {
        return MediaFactory.createMedia(libvlc, libvlcInstance, MediaFactory.newMediaInstance(libvlc, libvlcInstance, mrl), options);
    }

    public static Media newMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia, String ... options) {
        return MediaFactory.createMedia(libvlc, libvlcInstance, MediaFactory.newMediaInstance(libvlc, libvlcInstance, callbackMedia), options);
    }

    public static Media newMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMedia(libvlc, libvlcInstance, MediaFactory.retain(libvlc, mediaRef.mediaInstance()), options);
    }

    public static Media newMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMedia(libvlc, libvlcInstance, MediaFactory.retain(libvlc, media.mediaInstance()), options);
    }

    public static Media duplicateMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMedia(libvlc, libvlcInstance, libvlc.libvlc_media_duplicate(media.mediaInstance()), options);
    }

    private static libvlc_media_t newMediaInstance(LibVlc libvlc, libvlc_instance_t libvlcInstance, String mrl) {
        return MediaResourceLocator.isLocation(mrl = MediaResourceLocator.encodeMrl(mrl)) ? libvlc.libvlc_media_new_location(libvlcInstance, mrl) : libvlc.libvlc_media_new_path(libvlcInstance, mrl);
    }

    private static libvlc_media_t newMediaInstance(LibVlc libvlc, libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia) {
        return libvlc.libvlc_media_new_callbacks(libvlcInstance, callbackMedia.getOpen(), callbackMedia.getRead(), callbackMedia.getSeek(), callbackMedia.getClose(), callbackMedia.getOpaque());
    }

    private static libvlc_media_t retain(LibVlc libvlc, libvlc_media_t mediaInstance) {
        libvlc.libvlc_media_retain(mediaInstance);
        return mediaInstance;
    }

    private static MediaRef createMediaRef(LibVlc libvlc, libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String[] options) {
        if (mediaInstance != null) {
            MediaOptions.addMediaOptions(libvlc, mediaInstance, options);
            return new MediaRef(libvlc, libvlcInstance, mediaInstance);
        }
        return null;
    }

    private static Media createMedia(LibVlc libvlc, libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        if (mediaInstance != null) {
            Media media = new Media(libvlc, libvlcInstance, mediaInstance);
            media.options().add(options);
            return media;
        }
        return null;
    }
}

