/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.OptionFlag;

final class MediaOptions {
    private MediaOptions() {
    }

    static boolean addMediaOptions(LibVlc libvlc, libvlc_media_t media, String ... mediaOptions) {
        if (media != null) {
            if (mediaOptions != null) {
                for (String mediaOption : mediaOptions) {
                    libvlc.libvlc_media_add_option(media, mediaOption);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean addMediaOptions(LibVlc libvlc, libvlc_media_t media, String[] mediaOptions, OptionFlag ... flags) {
        if (media != null) {
            int flagsValue = MediaOptions.flagsToInt(flags);
            for (String mediaOption : mediaOptions) {
                libvlc.libvlc_media_add_option_flag(media, mediaOption, flagsValue);
            }
            return true;
        }
        return false;
    }

    public static boolean addMediaOption(LibVlc libvlc, libvlc_media_t media, String mediaOption, OptionFlag ... flags) {
        if (media != null) {
            libvlc.libvlc_media_add_option_flag(media, mediaOption, MediaOptions.flagsToInt(flags));
            return true;
        }
        return false;
    }

    private static int flagsToInt(OptionFlag ... flags) {
        int result = 0;
        if (flags != null) {
            for (OptionFlag flag : flags) {
                result |= flag.intValue();
            }
        }
        return result;
    }
}

