/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_picture_t;
import uk.co.caprica.vlcj.binding.support.size_tByReference;
import uk.co.caprica.vlcj.media.PictureType;

public final class Picture {
    private final int width;
    private final int height;
    private final int stride;
    private final PictureType type;
    private final long time;
    private final byte[] buffer;
    private final int size;

    public Picture(LibVlc libvlc, libvlc_picture_t picture) {
        this.width = libvlc.libvlc_picture_get_width(picture);
        this.height = libvlc.libvlc_picture_get_height(picture);
        this.stride = libvlc.libvlc_picture_get_stride(picture);
        this.type = PictureType.pictureType(libvlc.libvlc_picture_type(picture));
        this.time = libvlc.libvlc_picture_get_time(picture);
        this.buffer = this.initBuffer(libvlc, picture);
        this.size = this.buffer.length;
    }

    private byte[] initBuffer(LibVlc libvlc, libvlc_picture_t picture) {
        size_tByReference size = new size_tByReference();
        Pointer pointer = libvlc.libvlc_picture_get_buffer(picture, size);
        return pointer.getByteArray(0L, size.getValue().intValue());
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int stride() {
        return this.stride;
    }

    public PictureType type() {
        return this.type;
    }

    public long time() {
        return this.time;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("width=").append(this.width).append(',');
        sb.append("height=").append(this.height).append(',');
        sb.append("stride=").append(this.stride).append(',');
        sb.append("type=").append((Object)this.type).append(',');
        sb.append("time=").append(this.time).append(',');
        sb.append("size=").append(this.time).append(']');
        return sb.toString();
    }
}

