/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media.discoverer;

import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_discoverer_t;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.MediaListRef;

public final class MediaDiscoverer {
    private final LibVlc libvlc;
    private final libvlc_media_discoverer_t discoverer;
    private final MediaList mediaList;

    MediaDiscoverer(LibVlc libvlc, libvlc_instance_t libvlcInstance, libvlc_media_discoverer_t discovererInstance) {
        this.libvlc = libvlc;
        this.discoverer = discovererInstance;
        this.mediaList = new MediaList(libvlc, libvlcInstance, libvlc.libvlc_media_discoverer_media_list(discovererInstance));
    }

    public boolean start() {
        return this.libvlc.libvlc_media_discoverer_start(this.discoverer) == 0;
    }

    public void stop() {
        this.libvlc.libvlc_media_discoverer_stop(this.discoverer);
    }

    public boolean isRunning() {
        return this.libvlc.libvlc_media_discoverer_is_running(this.discoverer) != 0;
    }

    public MediaList newNediaList() {
        return this.mediaList.newMediaList();
    }

    public MediaListRef newNediaListRef() {
        return this.mediaList.newMediaListRef();
    }

    public void release() {
        this.mediaList.release();
        this.libvlc.libvlc_media_discoverer_release(this.discoverer);
    }
}

