/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.NativeString;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.medialist.BaseApi;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.MediaListRef;

public final class MediaApi
extends BaseApi {
    MediaApi(MediaList mediaList) {
        super(mediaList);
    }

    public boolean add(String mrl, String ... options) {
        return this.add(MediaFactory.newMediaRef(this.libvlc, this.libvlcInstance, mrl, options));
    }

    public boolean add(CallbackMedia callbackMedia, String ... options) {
        return this.add(MediaFactory.newMediaRef(this.libvlc, this.libvlcInstance, callbackMedia, options));
    }

    public boolean add(MediaRef mediaRef, String ... options) {
        return this.add(MediaFactory.newMediaRef(this.libvlc, this.libvlcInstance, mediaRef, options));
    }

    private boolean add(MediaRef mediaRef) {
        if (mediaRef != null && !this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = this.libvlc.libvlc_media_list_add_media(this.mediaListInstance, mediaRef.mediaInstance()) == 0;
                return bl;
            }
            finally {
                this.unlock();
                mediaRef.release();
            }
        }
        return false;
    }

    public boolean insert(int index, String mrl, String ... options) {
        return this.insert(index, MediaFactory.newMediaRef(this.libvlc, this.libvlcInstance, mrl, options));
    }

    public boolean insert(int index, CallbackMedia callbackMedia, String ... options) {
        return this.insert(index, MediaFactory.newMediaRef(this.libvlc, this.libvlcInstance, callbackMedia, options));
    }

    public boolean insert(int index, MediaRef mediaRef, String ... options) {
        return this.insert(index, MediaFactory.newMediaRef(this.libvlc, this.libvlcInstance, mediaRef, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(int index, MediaRef mediaRef) {
        if (mediaRef != null && !this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = this.libvlc.libvlc_media_list_insert_media(this.mediaListInstance, mediaRef.mediaInstance(), index) == 0;
                return bl;
            }
            finally {
                this.unlock();
                mediaRef.release();
            }
        }
        return false;
    }

    public boolean remove(int index) {
        if (!this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, index) == 0;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public boolean clear() {
        if (!this.isReadOnly()) {
            this.lock();
            try {
                int result;
                while ((result = this.libvlc.libvlc_media_list_remove_index(this.mediaListInstance, 0)) == 0) {
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public int count() {
        this.lock();
        try {
            int n = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mrls() {
        this.lock();
        try {
            int count = this.libvlc.libvlc_media_list_count(this.mediaListInstance);
            ArrayList<String> result = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                libvlc_media_t item = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, i);
                result.add(NativeString.copyNativeString((Pointer)this.libvlc.libvlc_media_get_mrl(item)));
                this.libvlc.libvlc_media_release(item);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mrl(int index) {
        this.lock();
        try {
            libvlc_media_t media = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, index);
            if (media != null) {
                try {
                    String string = NativeString.copyNativeString((Pointer)this.libvlc.libvlc_media_get_mrl(media));
                    return string;
                }
                finally {
                    this.libvlc.libvlc_media_release(media);
                }
            }
            String string = null;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaRef newMediaRef(int index) {
        this.lock();
        try {
            libvlc_media_t media = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, index);
            if (media != null) {
                MediaRef mediaRef = new MediaRef(this.libvlc, this.libvlcInstance, media);
                return mediaRef;
            }
            MediaRef mediaRef = null;
            return mediaRef;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Media newMedia(int index) {
        this.lock();
        try {
            libvlc_media_t media = this.libvlc.libvlc_media_list_item_at_index(this.mediaListInstance, index);
            if (media != null) {
                Media media2 = new Media(this.libvlc, this.libvlcInstance, media);
                return media2;
            }
            Media media3 = null;
            return media3;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isReadOnly() {
        return this.libvlc.libvlc_media_list_is_readonly(this.mediaListInstance) != 0;
    }

    public MediaList newMediaList() {
        return new MediaList(this.libvlc, this.libvlcInstance, this.mediaListInstance);
    }

    public MediaListRef newMediaListRef() {
        return new MediaListRef(this.libvlc, this.libvlcInstance, this.mediaListInstance);
    }

    private void lock() {
        this.libvlc.libvlc_media_list_lock(this.mediaListInstance);
    }

    private void unlock() {
        this.libvlc.libvlc_media_list_unlock(this.mediaListInstance);
    }
}

