/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.medialist.EventApi;
import uk.co.caprica.vlcj.medialist.MediaApi;
import uk.co.caprica.vlcj.medialist.MediaListRef;

public final class MediaList {
    protected final LibVlc libvlc;
    protected final libvlc_instance_t libvlcInstance;
    protected final libvlc_media_list_t mediaListInstance;
    private final MediaApi itemApi;
    private final EventApi eventApi;

    public MediaList(LibVlc libvlc, libvlc_instance_t libvlcInstance, libvlc_media_list_t mediaListInstance) {
        this.libvlc = libvlc;
        this.libvlcInstance = libvlcInstance;
        this.mediaListInstance = mediaListInstance;
        this.eventApi = new EventApi(this);
        this.itemApi = new MediaApi(this);
    }

    public EventApi events() {
        return this.eventApi;
    }

    public MediaApi media() {
        return this.itemApi;
    }

    public libvlc_media_list_t mediaListInstance() {
        return this.mediaListInstance;
    }

    public MediaListRef newMediaListRef() {
        this.libvlc.libvlc_media_list_retain(this.mediaListInstance);
        return new MediaListRef(this.libvlc, this.libvlcInstance, this.mediaListInstance);
    }

    public MediaList newMediaList() {
        this.libvlc.libvlc_media_list_retain(this.mediaListInstance);
        return new MediaList(this.libvlc, this.libvlcInstance, this.mediaListInstance);
    }

    public void release() {
        this.eventApi.release();
        this.itemApi.release();
        this.libvlc.libvlc_media_list_release(this.mediaListInstance);
    }
}

