/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.Logo;
import uk.co.caprica.vlcj.player.base.LogoPosition;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class LogoApi
extends BaseApi {
    LogoApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void enable(boolean enable) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    public void setDuration(int duration) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_delay.intValue(), duration);
    }

    public void setOpacity(int opacity) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    public void setOpacity(float opacity) {
        int opacityValue = Math.round(opacity * 255.0f);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacityValue);
    }

    public void setLocation(int x, int y) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    public void setPosition(LogoPosition position) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_position.intValue(), position.intValue());
    }

    public void setRepeat(int repeat) {
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_repeat.intValue(), repeat);
    }

    public void setFile(String logoFile) {
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    public void setImage(RenderedImage logoImage) {
        File file = null;
        try {
            file = File.createTempFile("vlcj-logo-", ".png");
            ImageIO.write(logoImage, "png", file);
            if (file.exists()) {
                this.setFile(file.getAbsolutePath());
                file.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set logo image", e);
        }
    }

    public void set(Logo logo) {
        logo.apply(this.mediaPlayer);
    }
}

