/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.io.File;
import java.util.List;
import uk.co.caprica.vlcj.binding.NativeUri;
import uk.co.caprica.vlcj.media.MediaSlaveType;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.Descriptions;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TrackDescription;

public final class SubpictureApi
extends BaseApi {
    SubpictureApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public int trackCount() {
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    public int track() {
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    public int setTrack(int spu) {
        this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
        return this.track();
    }

    public long delay() {
        return this.libvlc.libvlc_video_get_spu_delay(this.mediaPlayerInstance);
    }

    public void setDelay(long delay) {
        this.libvlc.libvlc_video_set_spu_delay(this.mediaPlayerInstance, delay);
    }

    public boolean setSubTitleFile(String subTitleFileName) {
        return this.setSubTitleUri(NativeUri.encodeFileUri((String)subTitleFileName));
    }

    public boolean setSubTitleFile(File subTitleFile) {
        return this.setSubTitleUri(NativeUri.encodeFileUri((String)subTitleFile.getAbsolutePath()));
    }

    public boolean setSubTitleUri(String uri) {
        return this.mediaPlayer.media().addSlave(MediaSlaveType.SUBTITLE, uri, true);
    }

    public List<TrackDescription> trackDescriptions() {
        return Descriptions.spuTrackDescriptions(this.libvlc, this.mediaPlayerInstance);
    }
}

