/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.NativeString;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.factory.AudioOutput;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.AudioDevice;

public final class AudioApi
extends BaseApi {
    AudioApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public List<AudioOutput> audioOutputs() {
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutputs = LibVlc.libvlc_audio_output_list_get((libvlc_instance_t)this.libvlcInstance);
        if (audioOutputs != null) {
            libvlc_audio_output_t audioOutput = audioOutputs;
            while (audioOutput != null) {
                String name = NativeString.copyNativeString((Pointer)audioOutput.psz_name);
                String description = NativeString.copyNativeString((Pointer)audioOutput.psz_description);
                result.add(new AudioOutput(name, description, this.getAudioOutputDevices(name)));
                audioOutput = audioOutput.p_next;
            }
            LibVlc.libvlc_audio_output_list_release((Pointer)audioOutputs.getPointer());
        }
        return result;
    }

    private List<AudioDevice> getAudioOutputDevices(String outputName) {
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_list_get((libvlc_instance_t)this.libvlcInstance, (String)outputName);
        if (audioDevices != null) {
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = NativeString.copyNativeString((Pointer)audioDevice.psz_device);
                String description = NativeString.copyNativeString((Pointer)audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release((Pointer)audioDevices.getPointer());
        }
        return result;
    }
}

