/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_rd_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_renderer_discoverer_t;
import uk.co.caprica.vlcj.binding.support.size_t;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.renderer.RendererDiscoverer;
import uk.co.caprica.vlcj.player.renderer.RendererDiscovererDescription;

public final class RendererApi
extends BaseApi {
    RendererApi(MediaPlayerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RendererDiscovererDescription> discoverers() {
        PointerByReference ref = new PointerByReference();
        size_t size = LibVlc.libvlc_renderer_discoverer_list_get((libvlc_instance_t)this.libvlcInstance, (PointerByReference)ref);
        try {
            int count = size.intValue();
            ArrayList<RendererDiscovererDescription> result = new ArrayList<RendererDiscovererDescription>(count);
            if (count > 0) {
                Pointer[] pointers;
                for (Pointer pointer : pointers = ref.getValue().getPointerArray(0L, count)) {
                    libvlc_rd_description_t description = (libvlc_rd_description_t)Structure.newInstance(libvlc_rd_description_t.class, (Pointer)pointer);
                    description.read();
                    result.add(new RendererDiscovererDescription(description.psz_name, description.psz_longname));
                }
            }
            ArrayList<RendererDiscovererDescription> arrayList = result;
            return arrayList;
        }
        finally {
            LibVlc.libvlc_renderer_discoverer_list_release((Pointer)ref.getValue(), (size_t)size);
        }
    }

    public RendererDiscoverer discoverer(String name) {
        libvlc_renderer_discoverer_t discoverer = LibVlc.libvlc_renderer_discoverer_new((libvlc_instance_t)this.libvlcInstance, (String)name);
        if (discoverer != null) {
            return new RendererDiscoverer(discoverer);
        }
        return null;
    }
}

