/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.NativeString;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_stats_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.AudioTrackInfo;
import uk.co.caprica.vlcj.media.BaseApi;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaStatistics;
import uk.co.caprica.vlcj.media.MediaType;
import uk.co.caprica.vlcj.media.TextTrackInfo;
import uk.co.caprica.vlcj.media.TrackInfo;
import uk.co.caprica.vlcj.media.TrackInformation;
import uk.co.caprica.vlcj.media.TrackType;
import uk.co.caprica.vlcj.media.VideoTrackInfo;
import uk.co.caprica.vlcj.player.base.State;

public final class InfoApi
extends BaseApi {
    private final libvlc_media_stats_t statsInstance = new libvlc_media_stats_t();

    InfoApi(Media media) {
        super(media);
    }

    public String mrl() {
        return NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_media_get_mrl((libvlc_media_t)this.mediaInstance));
    }

    public MediaType type() {
        return MediaType.mediaType(LibVlc.libvlc_media_get_type((libvlc_media_t)this.mediaInstance));
    }

    public State state() {
        return State.state(LibVlc.libvlc_media_get_state((libvlc_media_t)this.mediaInstance));
    }

    public long duration() {
        return LibVlc.libvlc_media_get_duration((libvlc_media_t)this.mediaInstance);
    }

    public List<? extends TrackInfo> tracks(TrackType ... types) {
        return TrackInformation.getTrackInfo(this.mediaInstance, types);
    }

    public List<AudioTrackInfo> audioTracks() {
        return this.tracks(TrackType.AUDIO);
    }

    public List<VideoTrackInfo> videoTracks() {
        return this.tracks(TrackType.VIDEO);
    }

    public List<TextTrackInfo> textTracks() {
        return this.tracks(TrackType.TEXT);
    }

    public boolean statistics(MediaStatistics mediaStatistics) {
        if (LibVlc.libvlc_media_get_stats((libvlc_media_t)this.mediaInstance, (libvlc_media_stats_t)this.statsInstance) != 0) {
            mediaStatistics.apply(this.statsInstance);
            return true;
        }
        return false;
    }

    public MediaStatistics statistics() {
        if (LibVlc.libvlc_media_get_stats((libvlc_media_t)this.mediaInstance, (libvlc_media_stats_t)this.statsInstance) != 0) {
            MediaStatistics mediaStatistics = new MediaStatistics();
            mediaStatistics.apply(this.statsInstance);
            return mediaStatistics;
        }
        return null;
    }
}

