/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_cancel_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_cbs;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_error_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_login_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_progress_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_display_question_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_id;
import uk.co.caprica.vlcj.binding.internal.libvlc_dialog_update_progress_cb;
import uk.co.caprica.vlcj.factory.DialogHandler;
import uk.co.caprica.vlcj.factory.DialogId;
import uk.co.caprica.vlcj.factory.DialogQuestionType;
import uk.co.caprica.vlcj.factory.DialogType;

public final class Dialogs {
    private final libvlc_dialog_cbs callbacks;
    private final List<DialogHandler> handlerList = new CopyOnWriteArrayList<DialogHandler>();

    Dialogs(DialogType ... dialogTypes) {
        this.callbacks = this.createCallbacks(dialogTypes);
    }

    public void addDialogHandler(DialogHandler handler) {
        this.handlerList.add(handler);
    }

    public void removeDialogHandler(DialogHandler handler) {
        this.handlerList.remove(handler);
    }

    libvlc_dialog_cbs callbacks() {
        return this.callbacks;
    }

    private libvlc_dialog_cbs createCallbacks(DialogType ... dialogTypes) {
        libvlc_dialog_cbs callbacks = new libvlc_dialog_cbs();
        HashSet enableTypes = new HashSet();
        Collections.addAll(enableTypes, dialogTypes != null && dialogTypes.length > 0 ? dialogTypes : DialogType.values());
        callbacks.pf_display_error = enableTypes.contains((Object)DialogType.ERROR) ? new DisplayError() : null;
        callbacks.pf_display_login = enableTypes.contains((Object)DialogType.LOGIN) ? new DisplayLogin() : null;
        callbacks.pf_display_question = enableTypes.contains((Object)DialogType.QUESTION) ? new DisplayQuestion() : null;
        callbacks.pf_display_progress = enableTypes.contains((Object)DialogType.PROGRESS) ? new DisplayProgress() : null;
        callbacks.pf_update_progress = enableTypes.contains((Object)DialogType.PROGRESS) ? new UpdateProgress() : null;
        callbacks.pf_cancel = new Cancel();
        return callbacks;
    }

    private Long userData(Pointer pointer) {
        return pointer != null ? Long.valueOf(Pointer.nativeValue((Pointer)pointer)) : null;
    }

    private DialogId dialogId(libvlc_dialog_id id) {
        return new DialogId(id);
    }

    private void onDisplayError(Long userData, String title, String text) {
        for (DialogHandler handler : this.handlerList) {
            handler.displayError(userData, title, text);
        }
    }

    private void onDisplayLogin(Long userData, DialogId id, String title, String text, String defaultUsername, boolean askStore) {
        for (DialogHandler handler : this.handlerList) {
            handler.displayLogin(userData, id, title, text, defaultUsername, askStore);
        }
    }

    private void onDisplayQuestion(Long userData, DialogId id, String title, String text, int type, String cancel, String action1, String action2) {
        for (DialogHandler handler : this.handlerList) {
            handler.displayQuestion(userData, id, title, text, DialogQuestionType.questionType(type), cancel, action1, action2);
        }
    }

    private void onDisplayProgress(Long userData, DialogId id, String title, String text, int indeterminate, float position, String cancel) {
        for (DialogHandler handler : this.handlerList) {
            handler.displayProgress(userData, id, title, text, indeterminate, position, cancel);
        }
    }

    private void onCancel(Long userData, DialogId id) {
        for (DialogHandler handler : this.handlerList) {
            handler.cancel(userData, id);
        }
    }

    private void onUpdateProgress(Long userData, DialogId id, float position, String text) {
        for (DialogHandler handler : this.handlerList) {
            handler.updateProgress(userData, id, position, text);
        }
    }

    private class UpdateProgress
    implements libvlc_dialog_update_progress_cb {
        private UpdateProgress() {
        }

        public void callback(Pointer p_data, libvlc_dialog_id p_id, float f_position, String psz_text) {
            Dialogs.this.onUpdateProgress(Dialogs.this.userData(p_data), Dialogs.this.dialogId(p_id), f_position, psz_text);
        }
    }

    private class Cancel
    implements libvlc_dialog_cancel_cb {
        private Cancel() {
        }

        public void callback(Pointer p_data, libvlc_dialog_id p_id) {
            Dialogs.this.onCancel(Dialogs.this.userData(p_data), Dialogs.this.dialogId(p_id));
        }
    }

    private class DisplayProgress
    implements libvlc_dialog_display_progress_cb {
        private DisplayProgress() {
        }

        public void callback(Pointer p_data, libvlc_dialog_id p_id, String psz_title, String psz_text, int b_indeterminate, float f_position, String psz_cancel) {
            Dialogs.this.onDisplayProgress(Dialogs.this.userData(p_data), Dialogs.this.dialogId(p_id), psz_title, psz_text, b_indeterminate, f_position, psz_cancel);
        }
    }

    private class DisplayQuestion
    implements libvlc_dialog_display_question_cb {
        private DisplayQuestion() {
        }

        public void callback(Pointer p_data, libvlc_dialog_id p_id, String psz_title, String psz_text, int i_type, String psz_cancel, String psz_action1, String psz_action2) {
            Dialogs.this.onDisplayQuestion(Dialogs.this.userData(p_data), Dialogs.this.dialogId(p_id), psz_title, psz_text, i_type, psz_cancel, psz_action1, psz_action2);
        }
    }

    private class DisplayLogin
    implements libvlc_dialog_display_login_cb {
        private DisplayLogin() {
        }

        public void callback(Pointer p_data, libvlc_dialog_id p_id, String psz_title, String psz_text, String psz_default_username, int b_ask_store) {
            Dialogs.this.onDisplayLogin(Dialogs.this.userData(p_data), Dialogs.this.dialogId(p_id), psz_title, psz_text, psz_default_username, b_ask_store != 0);
        }
    }

    private class DisplayError
    implements libvlc_dialog_display_error_cb {
        private DisplayError() {
        }

        public void callback(Pointer p_data, String psz_title, String psz_text) {
            Dialogs.this.onDisplayError(Dialogs.this.userData(p_data), psz_title, psz_text);
        }
    }
}

