/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerLatch;

public final class ControlsApi
extends BaseApi {
    private boolean repeat;

    ControlsApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void play() {
        this.mediaPlayer.onBeforePlay();
        LibVlc.libvlc_media_player_play((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public boolean start() {
        return new MediaPlayerLatch(this.mediaPlayer).play();
    }

    public void stop() {
        LibVlc.libvlc_media_player_stop((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void setPause(boolean pause) {
        LibVlc.libvlc_media_player_set_pause((libvlc_media_player_t)this.mediaPlayerInstance, (int)(pause ? 1 : 0));
    }

    public void pause() {
        LibVlc.libvlc_media_player_pause((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void nextFrame() {
        LibVlc.libvlc_media_player_next_frame((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void skipTime(long delta) {
        long current = this.mediaPlayer.status().time();
        if (current != -1L) {
            this.setTime(current + delta);
        }
    }

    public void skipPosition(float delta) {
        float current = this.mediaPlayer.status().position();
        if (current != -1.0f) {
            this.setPosition(current + delta);
        }
    }

    public void setTime(long time) {
        LibVlc.libvlc_media_player_set_time((libvlc_media_player_t)this.mediaPlayerInstance, (long)Math.max(time, 0L));
    }

    public void setPosition(float position) {
        LibVlc.libvlc_media_player_set_position((libvlc_media_player_t)this.mediaPlayerInstance, (float)Math.max(position, 0.0f));
    }

    public boolean setRate(float rate) {
        return LibVlc.libvlc_media_player_set_rate((libvlc_media_player_t)this.mediaPlayerInstance, (float)rate) != -1;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getRepeat() {
        return this.repeat;
    }
}

