/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.medialist;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.medialist.BaseApi;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.MediaListRef;

public final class MediaApi
extends BaseApi {
    MediaApi(MediaList mediaList) {
        super(mediaList);
    }

    public boolean add(String mrl, String ... options) {
        return this.add(MediaFactory.newMediaRef(this.libvlcInstance, mrl, options));
    }

    public boolean add(CallbackMedia callbackMedia, String ... options) {
        return this.add(MediaFactory.newMediaRef(this.libvlcInstance, callbackMedia, options));
    }

    public boolean add(MediaRef mediaRef, String ... options) {
        return this.add(MediaFactory.newMediaRef(this.libvlcInstance, mediaRef, options));
    }

    private boolean add(MediaRef mediaRef) {
        if (mediaRef != null && !this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = LibVlc.libvlc_media_list_add_media((libvlc_media_list_t)this.mediaListInstance, (libvlc_media_t)mediaRef.mediaInstance()) == 0;
                return bl;
            }
            finally {
                this.unlock();
                mediaRef.release();
            }
        }
        return false;
    }

    public boolean insert(int index, String mrl, String ... options) {
        return this.insert(index, MediaFactory.newMediaRef(this.libvlcInstance, mrl, options));
    }

    public boolean insert(int index, CallbackMedia callbackMedia, String ... options) {
        return this.insert(index, MediaFactory.newMediaRef(this.libvlcInstance, callbackMedia, options));
    }

    public boolean insert(int index, MediaRef mediaRef, String ... options) {
        return this.insert(index, MediaFactory.newMediaRef(this.libvlcInstance, mediaRef, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(int index, MediaRef mediaRef) {
        if (mediaRef != null && !this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = LibVlc.libvlc_media_list_insert_media((libvlc_media_list_t)this.mediaListInstance, (libvlc_media_t)mediaRef.mediaInstance(), (int)index) == 0;
                return bl;
            }
            finally {
                this.unlock();
                mediaRef.release();
            }
        }
        return false;
    }

    public boolean remove(int index) {
        if (!this.isReadOnly()) {
            this.lock();
            try {
                boolean bl = LibVlc.libvlc_media_list_remove_index((libvlc_media_list_t)this.mediaListInstance, (int)index) == 0;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public boolean clear() {
        if (!this.isReadOnly()) {
            this.lock();
            try {
                int result;
                while ((result = LibVlc.libvlc_media_list_remove_index((libvlc_media_list_t)this.mediaListInstance, (int)0)) == 0) {
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public int count() {
        this.lock();
        try {
            int n = LibVlc.libvlc_media_list_count((libvlc_media_list_t)this.mediaListInstance);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mrls() {
        this.lock();
        try {
            int count = LibVlc.libvlc_media_list_count((libvlc_media_list_t)this.mediaListInstance);
            ArrayList<String> result = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                libvlc_media_t item = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)i);
                result.add(NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_media_get_mrl((libvlc_media_t)item)));
                LibVlc.libvlc_media_release((libvlc_media_t)item);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mrl(int index) {
        this.lock();
        try {
            libvlc_media_t media = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)index);
            if (media != null) {
                try {
                    String string = NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_media_get_mrl((libvlc_media_t)media));
                    return string;
                }
                finally {
                    LibVlc.libvlc_media_release((libvlc_media_t)media);
                }
            }
            String string = null;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaRef newMediaRef(int index) {
        this.lock();
        try {
            libvlc_media_t media = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)index);
            if (media != null) {
                MediaRef mediaRef = new MediaRef(this.libvlcInstance, media);
                return mediaRef;
            }
            MediaRef mediaRef = null;
            return mediaRef;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Media newMedia(int index) {
        this.lock();
        try {
            libvlc_media_t media = LibVlc.libvlc_media_list_item_at_index((libvlc_media_list_t)this.mediaListInstance, (int)index);
            if (media != null) {
                Media media2 = new Media(this.libvlcInstance, media);
                return media2;
            }
            Media media3 = null;
            return media3;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isReadOnly() {
        return LibVlc.libvlc_media_list_is_readonly((libvlc_media_list_t)this.mediaListInstance) != 0;
    }

    public MediaList newMediaList() {
        return new MediaList(this.libvlcInstance, this.mediaListInstance);
    }

    public MediaListRef newMediaListRef() {
        return new MediaListRef(this.libvlcInstance, this.mediaListInstance);
    }

    private void lock() {
        LibVlc.libvlc_media_list_lock((libvlc_media_list_t)this.mediaListInstance);
    }

    private void unlock() {
        LibVlc.libvlc_media_list_unlock((libvlc_media_list_t)this.mediaListInstance);
    }
}

