/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.player.base.LogoPosition;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class Logo {
    private Integer intOpacity;
    private Float floatOpacity;
    private Integer duration;
    private Integer x;
    private Integer y;
    private LogoPosition position;
    private Integer repeat;
    private List<String> files = new ArrayList<String>();
    private RenderedImage image;
    private boolean enable;

    public static Logo logo() {
        return new Logo();
    }

    private Logo() {
    }

    public Logo duration(int duration) {
        this.duration = duration;
        return this;
    }

    public Logo opacity(int opacity) {
        this.intOpacity = opacity;
        return this;
    }

    public Logo opacity(float opacity) {
        this.floatOpacity = Float.valueOf(opacity);
        return this;
    }

    public Logo location(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Logo position(LogoPosition position) {
        this.position = position;
        return this;
    }

    public Logo repeat(int repeat) {
        this.repeat = repeat;
        return this;
    }

    public Logo file(String file) {
        return this.addFileSpec(file);
    }

    public Logo file(String file, Integer duration, Integer opacity) {
        return this.addFileSpec(String.format("%s,%s,%s", file, duration == null ? "" : duration, opacity == null ? "" : opacity));
    }

    public Logo file(File file) {
        return this.file(file.getAbsolutePath());
    }

    public Logo file(File file, Integer duration, Integer opacity) {
        return this.file(file.getAbsolutePath(), duration, opacity);
    }

    public Logo image(RenderedImage image) {
        this.image = image;
        return this;
    }

    public Logo enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public Logo enable() {
        this.enable = true;
        return this;
    }

    public Logo disable() {
        this.enable = false;
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getIntegerOpacity() {
        return this.intOpacity;
    }

    public Float getFloatOpacity() {
        return this.floatOpacity;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    public LogoPosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.convertFileSpecs();
    }

    public RenderedImage getImage() {
        return this.image;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void apply(MediaPlayer mediaPlayer) {
        if (this.duration != null) {
            mediaPlayer.logo().setDuration(this.duration);
        }
        if (this.intOpacity != null) {
            mediaPlayer.logo().setOpacity(this.intOpacity);
        }
        if (this.floatOpacity != null) {
            mediaPlayer.logo().setOpacity(this.floatOpacity.floatValue());
        }
        if (this.x != null && this.y != null && this.x >= 0 && this.y >= 0) {
            mediaPlayer.logo().setLocation(this.x, this.y);
        }
        if (this.position != null) {
            mediaPlayer.logo().setPosition(this.position);
        }
        if (this.repeat != null) {
            mediaPlayer.logo().setRepeat(this.repeat);
        }
        if (!this.files.isEmpty()) {
            mediaPlayer.logo().setFile(this.convertFileSpecs());
        }
        if (this.image != null) {
            mediaPlayer.logo().setImage(this.image);
        }
        if (this.enable) {
            mediaPlayer.logo().enable(true);
        }
    }

    private Logo addFileSpec(String fileSpec) {
        this.files.add(fileSpec);
        return this;
    }

    private String convertFileSpecs() {
        StringBuilder sb = new StringBuilder(this.files.size() * 40);
        for (String fileSpec : this.files) {
            sb.append(fileSpec).append(";");
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "intOpacity=" + this.intOpacity + ',' + "floatOpacity=" + this.floatOpacity + ',' + "x=" + this.x + ',' + "y=" + this.y + ',' + "position=" + (Object)((Object)this.position) + ',' + "files=" + this.files + ',' + "image=" + this.image + ',' + "enable=" + this.enable + ']';
    }
}

