/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_module_description_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.factory.ModuleDescription;
import uk.co.caprica.vlcj.log.NativeLog;
import uk.co.caprica.vlcj.media.TrackType;

public final class ApplicationApi
extends BaseApi {
    ApplicationApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public String version() {
        return LibVlc.libvlc_get_version();
    }

    public String compiler() {
        return LibVlc.libvlc_get_compiler();
    }

    public String changeset() {
        return LibVlc.libvlc_get_changeset();
    }

    public int abiVersion() {
        return LibVlc.libvlc_abi_version();
    }

    public void setUserAgent(String userAgent) {
        this.setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, String httpUserAgent) {
        LibVlc.libvlc_set_user_agent((libvlc_instance_t)this.libvlcInstance, (String)userAgent, (String)httpUserAgent);
    }

    public void setApplicationId(String id, String version, String icon) {
        LibVlc.libvlc_set_app_id((libvlc_instance_t)this.libvlcInstance, (String)id, (String)version, (String)icon);
    }

    public NativeLog newLog() {
        return new NativeLog(this.libvlcInstance);
    }

    public long clock() {
        return LibVlc.libvlc_clock();
    }

    public String codecDescription(TrackType type, int codec) {
        return LibVlc.libvlc_media_get_codec_description((int)type.intValue(), (int)codec);
    }

    public List<ModuleDescription> audioFilters() {
        libvlc_module_description_t moduleDescriptions = LibVlc.libvlc_audio_filter_list_get((libvlc_instance_t)this.libvlcInstance);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        LibVlc.libvlc_module_description_list_release((Pointer)moduleDescriptions.getPointer());
        return result;
    }

    public List<ModuleDescription> videoFilters() {
        libvlc_module_description_t moduleDescriptions = LibVlc.libvlc_video_filter_list_get((libvlc_instance_t)this.libvlcInstance);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        LibVlc.libvlc_module_description_list_release((Pointer)moduleDescriptions.getPointer());
        return result;
    }

    private List<ModuleDescription> getModuleDescriptions(libvlc_module_description_t moduleDescriptions) {
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        libvlc_module_description_t moduleDescription = moduleDescriptions;
        while (moduleDescription != null) {
            result.add(new ModuleDescription(moduleDescription.psz_name, moduleDescription.psz_shortname, moduleDescription.psz_longname, moduleDescription.psz_help, moduleDescription.psz_help_html));
            moduleDescription = moduleDescription.p_next;
        }
        return result;
    }
}

