/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.strategy;

import com.sun.jna.NativeLibrary;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;

public abstract class BaseNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private final Pattern[] patternsToMatch;
    private final String[] pluginPathFormats;

    public BaseNativeDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        this.patternsToMatch = new Pattern[filenamePatterns.length];
        for (int i = 0; i < filenamePatterns.length; ++i) {
            this.patternsToMatch[i] = Pattern.compile(filenamePatterns[i]);
        }
        this.pluginPathFormats = pluginPathFormats;
    }

    @Override
    public final String discover() {
        for (String discoveryDirectory : this.discoveryDirectories()) {
            String directoryResult = this.discover(new File(discoveryDirectory));
            if (directoryResult == null) continue;
            return directoryResult;
        }
        return null;
    }

    protected abstract List<String> discoveryDirectories();

    private String discover(File discoveryDirectory) {
        if (!discoveryDirectory.exists() || !discoveryDirectory.isDirectory()) {
            return null;
        }
        if (this.find(discoveryDirectory)) {
            return discoveryDirectory.getAbsolutePath();
        }
        File[] subDirs = discoveryDirectory.listFiles(File::isDirectory);
        if (subDirs != null) {
            for (File subDir : subDirs) {
                String result = this.discover(subDir);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private boolean find(File dir) {
        File[] files = dir.listFiles(File::isFile);
        if (files != null) {
            HashSet<String> matches = new HashSet<String>(this.patternsToMatch.length);
            for (File file : files) {
                for (Pattern pattern : this.patternsToMatch) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.matches()) continue;
                    matches.add(pattern.pattern());
                    if (matches.size() != this.patternsToMatch.length) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public final boolean onFound(String path) {
        NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcCoreLibraryName(), (String)path);
        NativeLibrary.getInstance((String)RuntimeUtil.getLibVlcCoreLibraryName());
        return true;
    }

    @Override
    public final boolean onSetPluginPath(String path) {
        for (String pathFormat : this.pluginPathFormats) {
            String pluginPath = String.format(pathFormat, path);
            if (!new File(pluginPath).exists()) continue;
            return this.setPluginPath(pluginPath);
        }
        return false;
    }

    protected abstract boolean setPluginPath(String var1);
}

