/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.media.BaseApi;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.Meta;
import uk.co.caprica.vlcj.media.MetaData;

public final class MetaApi
extends BaseApi {
    MetaApi(Media media) {
        super(media);
    }

    public String get(Meta meta) {
        return this.getMetaValue(LibVlc.libvlc_media_get_meta((libvlc_media_t)this.mediaInstance, (int)meta.intValue()));
    }

    public void set(Meta meta, String value) {
        LibVlc.libvlc_media_set_meta((libvlc_media_t)this.mediaInstance, (int)meta.intValue(), (String)value);
    }

    public List<String> getExtraNames() {
        Pointer[] namePointers;
        PointerByReference namesPointer = new PointerByReference();
        int namesCount = LibVlc.libvlc_media_get_meta_extra_names((libvlc_media_t)this.mediaInstance, (PointerByReference)namesPointer);
        ArrayList<String> result = new ArrayList<String>(namesCount);
        for (Pointer namePointer : namePointers = namesPointer.getValue().getPointerArray(0L, namesCount)) {
            String name = NativeString.copyNativeString((Pointer)namePointer);
            result.add(name);
        }
        LibVlc.libvlc_media_meta_extra_names_release((Pointer)namesPointer.getValue(), (int)namesCount);
        return result;
    }

    public String getExtra(String name) {
        return this.getMetaValue(LibVlc.libvlc_media_get_meta_extra((libvlc_media_t)this.mediaInstance, (String)name));
    }

    public void setExtra(String name, String value) {
        LibVlc.libvlc_media_set_meta_extra((libvlc_media_t)this.mediaInstance, (String)name, (String)value);
    }

    public boolean save() {
        return LibVlc.libvlc_media_save_meta((libvlc_instance_t)this.libvlcInstance, (libvlc_media_t)this.mediaInstance) != 0;
    }

    public MetaData asMetaData() {
        HashMap<Meta, String> values = new HashMap<Meta, String>(Meta.values().length);
        for (Meta meta : Meta.values()) {
            String value = this.get(meta);
            if (value == null) continue;
            values.put(meta, value);
        }
        List<String> extraNames = this.getExtraNames();
        TreeMap<String, String> extraMeta = new TreeMap<String, String>();
        for (String extraName : extraNames) {
            String extraValue = this.getExtra(extraName);
            extraMeta.put(extraName, extraValue);
        }
        return new MetaData(values, extraMeta);
    }

    private String getMetaValue(Pointer pointer) {
        return NativeString.copyAndFreeNativeString((Pointer)pointer);
    }
}

