/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.binding.support.strings.NativeString;
import uk.co.caprica.vlcj.player.base.AudioCallbacks;
import uk.co.caprica.vlcj.player.base.AudioDevice;
import uk.co.caprica.vlcj.player.base.AudioMixMode;
import uk.co.caprica.vlcj.player.base.AudioStereoMode;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.Equalizer;
import uk.co.caprica.vlcj.player.base.EqualizerListener;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.callback.AudioCallback;

public final class AudioApi
extends BaseApi
implements EqualizerListener {
    private final AudioCallbacks audioCallbacks;
    private Equalizer equalizer;
    private libvlc_equalizer_t equalizerInstance;

    AudioApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
        this.audioCallbacks = new AudioCallbacks(mediaPlayer);
    }

    public boolean setOutput(String output) {
        return 0 == LibVlc.libvlc_audio_output_set((libvlc_media_player_t)this.mediaPlayerInstance, (String)output);
    }

    public String outputDevice() {
        return NativeString.copyAndFreeNativeString((Pointer)LibVlc.libvlc_audio_output_device_get((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    public void setOutputDevice(String outputDeviceId) {
        LibVlc.libvlc_audio_output_device_set((libvlc_media_player_t)this.mediaPlayerInstance, (String)outputDeviceId);
    }

    public List<AudioDevice> outputDevices() {
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_enum((libvlc_media_player_t)this.mediaPlayerInstance);
        if (audioDevices != null) {
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = NativeString.copyNativeString((Pointer)audioDevice.psz_device);
                String description = NativeString.copyNativeString((Pointer)audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release((Pointer)audioDevices.getPointer());
        }
        return result;
    }

    public boolean mute() {
        LibVlc.libvlc_audio_toggle_mute((libvlc_media_player_t)this.mediaPlayerInstance);
        return this.isMute();
    }

    public void setMute(boolean mute) {
        LibVlc.libvlc_audio_set_mute((libvlc_media_player_t)this.mediaPlayerInstance, (int)(mute ? 1 : 0));
    }

    public boolean isMute() {
        return LibVlc.libvlc_audio_get_mute((libvlc_media_player_t)this.mediaPlayerInstance) != 0;
    }

    public int volume() {
        return LibVlc.libvlc_audio_get_volume((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public boolean setVolume(int volume) {
        return LibVlc.libvlc_audio_set_volume((libvlc_media_player_t)this.mediaPlayerInstance, (int)volume) == 0;
    }

    public AudioStereoMode stereoMode() {
        return AudioStereoMode.audioStereoMode(LibVlc.libvlc_audio_get_stereomode((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    public boolean setStereoMode(AudioStereoMode stereoMode) {
        return LibVlc.libvlc_audio_set_stereomode((libvlc_media_player_t)this.mediaPlayerInstance, (int)stereoMode.intValue()) == 0;
    }

    public AudioMixMode getMixMode() {
        return AudioMixMode.audioMixMode(LibVlc.libvlc_audio_get_mixmode((libvlc_media_player_t)this.mediaPlayerInstance));
    }

    public boolean setMixMode(AudioMixMode mixMode) {
        return LibVlc.libvlc_audio_set_mixmode((libvlc_media_player_t)this.mediaPlayerInstance, (int)mixMode.intValue()) == 0;
    }

    public long delay() {
        return LibVlc.libvlc_audio_get_delay((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void setDelay(long delay) {
        LibVlc.libvlc_audio_set_delay((libvlc_media_player_t)this.mediaPlayerInstance, (long)delay);
    }

    public Equalizer equalizer() {
        return this.equalizer;
    }

    public void setEqualizer(Equalizer equalizer) {
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            LibVlc.libvlc_audio_equalizer_release((libvlc_equalizer_t)this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.equalizer = equalizer;
        if (this.equalizer != null) {
            this.equalizerInstance = LibVlc.libvlc_audio_equalizer_new();
            this.equalizer.addEqualizerListener(this);
        }
        this.applyEqualizer();
    }

    @Override
    public final void equalizerChanged(Equalizer equalizer) {
        this.applyEqualizer();
    }

    private void applyEqualizer() {
        if (this.equalizerInstance != null) {
            LibVlc.libvlc_audio_equalizer_set_preamp((libvlc_equalizer_t)this.equalizerInstance, (float)this.equalizer.preamp());
            for (int i = 0; i < LibVlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                LibVlc.libvlc_audio_equalizer_set_amp_at_index((libvlc_equalizer_t)this.equalizerInstance, (float)this.equalizer.amp(i), (int)i);
            }
            LibVlc.libvlc_media_player_set_equalizer((libvlc_media_player_t)this.mediaPlayerInstance, (libvlc_equalizer_t)this.equalizerInstance);
        } else {
            LibVlc.libvlc_media_player_set_equalizer((libvlc_media_player_t)this.mediaPlayerInstance, null);
        }
    }

    public void callback(String format, int rate, int channels, AudioCallback audioCallback) {
        this.callback(format, rate, channels, audioCallback, false);
    }

    public void callback(String format, int rate, int channels, AudioCallback audioCallback, boolean manageVolume) {
        this.audioCallbacks.callback(format, rate, channels, audioCallback, manageVolume);
    }

    @Override
    protected void release() {
        this.setEqualizer(null);
    }
}

