/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerPlayLatch;
import uk.co.caprica.vlcj.player.base.MediaPlayerStopLatch;

public final class ControlsApi
extends BaseApi {
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private boolean repeat;

    ControlsApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public boolean play() {
        this.mediaPlayer.onBeforePlay();
        return LibVlc.libvlc_media_player_play((libvlc_media_player_t)this.mediaPlayerInstance) == 0;
    }

    public boolean start() {
        return new MediaPlayerPlayLatch(this.mediaPlayer).play();
    }

    public boolean stop() {
        this.stopRequested.set(true);
        return new MediaPlayerStopLatch(this.mediaPlayer).stop();
    }

    public boolean stopAsync() {
        this.stopRequested.set(true);
        return LibVlc.libvlc_media_player_stop_async((libvlc_media_player_t)this.mediaPlayerInstance) == 0;
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    public void clearStopRequested() {
        this.stopRequested.set(false);
    }

    public void setPause(boolean pause) {
        LibVlc.libvlc_media_player_set_pause((libvlc_media_player_t)this.mediaPlayerInstance, (int)(pause ? 1 : 0));
    }

    public void pause() {
        LibVlc.libvlc_media_player_pause((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void nextFrame() {
        LibVlc.libvlc_media_player_next_frame((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public boolean skipTime(long delta) {
        long current = this.mediaPlayer.status().time();
        if (current != -1L) {
            return this.setTime(current + delta, false);
        }
        return false;
    }

    public boolean skipPosition(double delta) {
        double current = this.mediaPlayer.status().position();
        if (current != -1.0) {
            return this.setPosition(current + delta, false);
        }
        return false;
    }

    public boolean skipTime(long delta, boolean fast) {
        long current = this.mediaPlayer.status().time();
        if (current != -1L) {
            return this.setTime(current + delta, fast);
        }
        return false;
    }

    public boolean skipPosition(double delta, boolean fast) {
        double current = this.mediaPlayer.status().position();
        if (current != -1.0) {
            return this.setPosition(current + delta, fast);
        }
        return false;
    }

    public boolean setTime(long time) {
        return this.setTime(time, false);
    }

    public boolean setPosition(double position) {
        return this.setPosition(position, false);
    }

    public boolean setTime(long time, boolean fast) {
        return LibVlc.libvlc_media_player_set_time((libvlc_media_player_t)this.mediaPlayerInstance, (long)Math.max(time, 0L), (int)(fast ? 1 : 0)) == 0;
    }

    public boolean jumpTime(long time) {
        return LibVlc.libvlc_media_player_jump_time((libvlc_media_player_t)this.mediaPlayerInstance, (long)Math.max(time, 0L)) == 0;
    }

    public boolean setPosition(double position, boolean fast) {
        return LibVlc.libvlc_media_player_set_position((libvlc_media_player_t)this.mediaPlayerInstance, (double)Math.max(position, 0.0), (int)(fast ? 1 : 0)) == 0;
    }

    public boolean setABLoopTime(long aTime, long bTime) {
        return LibVlc.libvlc_media_player_set_abloop_time((libvlc_media_player_t)this.mediaPlayerInstance, (long)aTime, (long)bTime) == 0;
    }

    public boolean setABLoopPosition(double aPosition, double bPosition) {
        return LibVlc.libvlc_media_player_set_abloop_position((libvlc_media_player_t)this.mediaPlayerInstance, (double)aPosition, (double)bPosition) == 0;
    }

    public boolean resetABLoop() {
        return LibVlc.libvlc_media_player_reset_abloop((libvlc_media_player_t)this.mediaPlayerInstance) == 0;
    }

    public boolean setRate(float rate) {
        return LibVlc.libvlc_media_player_set_rate((libvlc_media_player_t)this.mediaPlayerInstance, (float)rate) != -1;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getRepeat() {
        return this.repeat;
    }
}

