/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.lib.LibVlc;
import uk.co.caprica.vlcj.player.base.AudioApi;
import uk.co.caprica.vlcj.player.base.ChapterApi;
import uk.co.caprica.vlcj.player.base.ControlsApi;
import uk.co.caprica.vlcj.player.base.EventApi;
import uk.co.caprica.vlcj.player.base.LogoApi;
import uk.co.caprica.vlcj.player.base.MarqueeApi;
import uk.co.caprica.vlcj.player.base.MediaApi;
import uk.co.caprica.vlcj.player.base.MenuApi;
import uk.co.caprica.vlcj.player.base.ProgramApi;
import uk.co.caprica.vlcj.player.base.RecordApi;
import uk.co.caprica.vlcj.player.base.RendererApi;
import uk.co.caprica.vlcj.player.base.RoleApi;
import uk.co.caprica.vlcj.player.base.SnapshotApi;
import uk.co.caprica.vlcj.player.base.StatusApi;
import uk.co.caprica.vlcj.player.base.SubitemApi;
import uk.co.caprica.vlcj.player.base.SubpictureApi;
import uk.co.caprica.vlcj.player.base.TeletextApi;
import uk.co.caprica.vlcj.player.base.TimeApi;
import uk.co.caprica.vlcj.player.base.TitleApi;
import uk.co.caprica.vlcj.player.base.TrackApi;
import uk.co.caprica.vlcj.player.base.VideoApi;
import uk.co.caprica.vlcj.support.eventmanager.TaskExecutor;

public class MediaPlayer {
    protected final libvlc_instance_t libvlcInstance;
    private final libvlc_media_player_t mediaPlayerInstance;
    private final TaskExecutor executor = new TaskExecutor();
    private Object userData;
    private final AudioApi audioApi;
    private final ChapterApi chapterApi;
    private final ControlsApi controlsApi;
    private final EventApi eventApi;
    private final LogoApi logoApi;
    private final MarqueeApi marqueeApi;
    private final MediaApi mediaApi;
    private final MenuApi menuApi;
    private final ProgramApi programApi;
    private final RecordApi recordApi;
    private final RendererApi rendererApi;
    private final RoleApi roleApi;
    private final SnapshotApi snapshotApi;
    private final StatusApi statusApi;
    private final SubitemApi subitemApi;
    private final SubpictureApi subpictureApi;
    private final TeletextApi teletextApi;
    private final TimeApi timeApi;
    private final TitleApi titleApi;
    private final TrackApi trackApi;
    private final VideoApi videoApi;

    public MediaPlayer(libvlc_instance_t instance) {
        this(instance, MediaPlayer.newNativeMediaPlayer(instance));
    }

    public MediaPlayer(libvlc_instance_t instance, libvlc_media_player_t mediaPlayerInstance) {
        this.libvlcInstance = instance;
        this.mediaPlayerInstance = mediaPlayerInstance;
        this.audioApi = new AudioApi(this);
        this.chapterApi = new ChapterApi(this);
        this.controlsApi = new ControlsApi(this);
        this.eventApi = new EventApi(this);
        this.logoApi = new LogoApi(this);
        this.marqueeApi = new MarqueeApi(this);
        this.mediaApi = new MediaApi(this);
        this.menuApi = new MenuApi(this);
        this.programApi = new ProgramApi(this);
        this.recordApi = new RecordApi(this);
        this.rendererApi = new RendererApi(this);
        this.roleApi = new RoleApi(this);
        this.snapshotApi = new SnapshotApi(this);
        this.statusApi = new StatusApi(this);
        this.subitemApi = new SubitemApi(this);
        this.subpictureApi = new SubpictureApi(this);
        this.teletextApi = new TeletextApi(this);
        this.timeApi = new TimeApi(this);
        this.titleApi = new TitleApi(this);
        this.trackApi = new TrackApi(this);
        this.videoApi = new VideoApi(this);
    }

    private static libvlc_media_player_t newNativeMediaPlayer(libvlc_instance_t instance) {
        libvlc_media_player_t result = LibVlc.libvlc_media_player_new((libvlc_instance_t)instance);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Failed to get a new native media player instance");
    }

    public final AudioApi audio() {
        return this.audioApi;
    }

    public final ChapterApi chapters() {
        return this.chapterApi;
    }

    public final ControlsApi controls() {
        return this.controlsApi;
    }

    public final EventApi events() {
        return this.eventApi;
    }

    public final LogoApi logo() {
        return this.logoApi;
    }

    public final MarqueeApi marquee() {
        return this.marqueeApi;
    }

    public final MediaApi media() {
        return this.mediaApi;
    }

    public final MenuApi menu() {
        return this.menuApi;
    }

    public final ProgramApi programs() {
        return this.programApi;
    }

    public final RecordApi record() {
        return this.recordApi;
    }

    public final RendererApi renderer() {
        return this.rendererApi;
    }

    public final RoleApi role() {
        return this.roleApi;
    }

    public final SnapshotApi snapshots() {
        return this.snapshotApi;
    }

    public final StatusApi status() {
        return this.statusApi;
    }

    public final SubitemApi subitems() {
        return this.subitemApi;
    }

    public final SubpictureApi subpictures() {
        return this.subpictureApi;
    }

    public final TeletextApi teletext() {
        return this.teletextApi;
    }

    public final TimeApi time() {
        return this.timeApi;
    }

    public final TitleApi titles() {
        return this.titleApi;
    }

    public final TrackApi tracks() {
        return this.trackApi;
    }

    public final VideoApi video() {
        return this.videoApi;
    }

    public final Object userData() {
        return this.userData;
    }

    public final void userData(Object userData) {
        this.userData = userData;
    }

    public final void submit(Runnable r) {
        this.executor.submit(r);
    }

    public final void release() {
        this.executor.release();
        this.onBeforeRelease();
        this.audioApi.release();
        this.chapterApi.release();
        this.controlsApi.release();
        this.eventApi.release();
        this.logoApi.release();
        this.marqueeApi.release();
        this.mediaApi.release();
        this.menuApi.release();
        this.programApi.release();
        this.recordApi.release();
        this.rendererApi.release();
        this.roleApi.release();
        this.snapshotApi.release();
        this.statusApi.release();
        this.subitemApi.release();
        this.subpictureApi.release();
        this.teletextApi.release();
        this.timeApi.release();
        this.titleApi.release();
        this.trackApi.release();
        this.videoApi.release();
        LibVlc.libvlc_media_player_release((libvlc_media_player_t)this.mediaPlayerInstance);
        this.onAfterRelease();
    }

    protected void onBeforePlay() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    public final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }
}

