/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.base.events.MediaPlayerEventFactory;

final class MediaPlayerReadyEventHandler
extends MediaPlayerEventAdapter {
    private boolean fired;

    MediaPlayerReadyEventHandler() {
    }

    @Override
    public void mediaChanged(MediaPlayer mediaPlayer, MediaRef media) {
        this.fired = false;
    }

    @Override
    public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
        if (!this.fired && newTime > 0L) {
            this.fired = true;
            mediaPlayer.events().raiseEvent(MediaPlayerEventFactory.createMediaPlayerReadyEvent(mediaPlayer));
        }
    }

    @Override
    public void positionChanged(MediaPlayer mediaPlayer, double newPosition) {
        if (!this.fired && newPosition > 0.0) {
            this.fired = true;
            mediaPlayer.events().raiseEvent(MediaPlayerEventFactory.createMediaPlayerReadyEvent(mediaPlayer));
        }
    }

    @Override
    public void stopped(MediaPlayer mediaPlayer) {
        this.fired = false;
    }
}

